"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSendMessage = exports.SendMessageProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_send_message_mutation = require("./use_send_message_mutation");
var _use_connector_selection = require("../../hooks/chat/use_connector_selection");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/context/send_message/send_message_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SendMessageContext = /*#__PURE__*/(0, _react.createContext)(null);
const SendMessageProvider = ({
  children
}) => {
  const connectorSelection = (0, _use_connector_selection.useConnectorSelection)();
  const {
    sendMessage,
    isResponseLoading,
    pendingMessage,
    error,
    errorSteps,
    agentReasoning,
    retry,
    canCancel,
    cancel,
    cleanConversation
  } = (0, _use_send_message_mutation.useSendMessageMutation)({
    connectorId: connectorSelection.selectedConnector
  });
  return /*#__PURE__*/_react.default.createElement(SendMessageContext.Provider, {
    value: {
      sendMessage,
      isResponseLoading,
      pendingMessage,
      error,
      errorSteps,
      agentReasoning,
      retry,
      canCancel,
      cancel,
      cleanConversation,
      connectorSelection: {
        selectedConnector: connectorSelection.selectedConnector,
        selectConnector: connectorSelection.selectConnector,
        defaultConnectorId: connectorSelection.defaultConnectorId
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, children);
};
exports.SendMessageProvider = SendMessageProvider;
const useSendMessage = () => {
  const context = (0, _react.useContext)(SendMessageContext);
  if (!context) {
    throw new Error('useSendMessage must be used within a SendMessageProvider');
  }
  return context;
};
exports.useSendMessage = useSendMessage;