"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableConversationsProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactQuery = require("@kbn/react-query");
var _conversation_context = require("./conversation_context");
var _onechat_services_context = require("../onechat_services_context");
var _send_message_context = require("../send_message/send_message_context");
var _use_conversation_actions = require("./use_conversation_actions");
var _use_persisted_conversation_id = require("../../hooks/use_persisted_conversation_id");
var _app_leave_context = require("../app_leave_context");
var _agent_builder_tour_context = require("../agent_builder_tour_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/context/conversation/embeddable_conversations_provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const noopOnAppLeave = () => {};
const EmbeddableConversationsProvider = ({
  children,
  coreStart,
  services,
  ...contextProps
}) => {
  // Track current props, starting with initial props
  const [currentProps, setCurrentProps] = (0, _react.useState)(contextProps);

  // Register callbacks to allow parent to update props and clear browserApiTools
  const onRegisterCallbacks = contextProps.onRegisterCallbacks;
  (0, _react.useEffect)(() => {
    if (onRegisterCallbacks) {
      onRegisterCallbacks({
        updateProps: newProps => setCurrentProps(newProps),
        resetBrowserApiTools: () => setCurrentProps(prevProps => ({
          ...prevProps,
          browserApiTools: undefined
        }))
      });
    }
  }, [onRegisterCallbacks]);

  // Create a QueryClient per instance to ensure cache isolation between multiple embeddable conversations
  const queryClient = (0, _react.useMemo)(() => new _reactQuery.QueryClient(), []);
  const kibanaServices = (0, _react.useMemo)(() => ({
    ...coreStart,
    plugins: {
      ...services.startDependencies
    }
  }), [coreStart, services.startDependencies]);
  const {
    persistedConversationId,
    updatePersistedConversationId
  } = (0, _use_persisted_conversation_id.usePersistedConversationId)({
    sessionTag: currentProps.sessionTag,
    agentId: currentProps.agentId
  });
  const hasInitializedConversationIdRef = (0, _react.useRef)(false);
  const setConversationId = (0, _react.useCallback)(id => {
    if (currentProps.newConversation && id) {
      // reset new conversation flag when there is a valid id
      setCurrentProps({
        ...currentProps,
        newConversation: undefined
      });
    }
    if (id !== persistedConversationId) {
      updatePersistedConversationId(id);
    }
  }, [currentProps, persistedConversationId, updatePersistedConversationId]);
  const validateAndSetConversationId = (0, _react.useCallback)(async id => {
    try {
      var _conversation$id;
      const conversation = await services.conversationsService.get({
        conversationId: id
      });
      setConversationId((_conversation$id = conversation.id) !== null && _conversation$id !== void 0 ? _conversation$id : undefined);
    } catch {
      setConversationId(undefined);
    }
  }, [services.conversationsService, setConversationId]);

  // One-time initialization per provider instance:
  // - If newConversation flag is set, clears the conversation ID to start fresh.
  // - Otherwise, if there's a persisted conversation ID, validates and restores it.
  // - Otherwise, clears the conversation ID.
  // Guarded by hasInitializedConversationIdRef to prevent re-running on subsequent renders.
  (0, _react.useEffect)(() => {
    if (hasInitializedConversationIdRef.current) return;
    if (contextProps.newConversation) {
      setConversationId(undefined);
    } else if (persistedConversationId) {
      validateAndSetConversationId(persistedConversationId);
    } else {
      setConversationId(undefined);
    }
    hasInitializedConversationIdRef.current = true;
  }, [contextProps.newConversation, persistedConversationId, setConversationId, validateAndSetConversationId]);
  const onConversationCreated = (0, _react.useCallback)(({
    conversationId: id
  }) => {
    setConversationId(id);
  }, [setConversationId]);
  const onDeleteConversation = (0, _react.useCallback)(() => {
    setConversationId(undefined);
  }, [setConversationId]);

  // Derived conversation ID
  const conversationId = (0, _react.useMemo)(() => {
    if (currentProps.newConversation) {
      return undefined;
    }
    // After initialization, always use persisted ID
    return persistedConversationId;
  }, [currentProps, persistedConversationId]);
  const conversationActions = (0, _use_conversation_actions.useConversationActions)({
    conversationId,
    queryClient,
    conversationsService: services.conversationsService,
    onConversationCreated,
    onDeleteConversation
  });

  // Resets the {initialMessage} and {autoSendInitialMessage} flags after an initial message has been sent or set in the {ConversationInput} component
  const resetInitialMessage = (0, _react.useCallback)(() => {
    setCurrentProps(prevProps => ({
      ...prevProps,
      initialMessage: undefined,
      autoSendInitialMessage: false
    }));
  }, []);

  // Resets the {attachments} array after attachment(s) have been sent as part of a Conversation Round.
  const resetAttachments = (0, _react.useCallback)(() => {
    setCurrentProps(prevProps => ({
      ...prevProps,
      attachments: undefined
    }));
  }, []);
  const removeAttachment = (0, _react.useCallback)(attachmentIndex => {
    setCurrentProps(prevProps => {
      var _prevProps$attachment;
      return {
        ...prevProps,
        attachments: (_prevProps$attachment = prevProps.attachments) === null || _prevProps$attachment === void 0 ? void 0 : _prevProps$attachment.filter((_, index) => index !== attachmentIndex)
      };
    });
  }, []);
  const conversationContextValue = (0, _react.useMemo)(() => {
    var _currentProps$autoSen;
    return {
      conversationId,
      shouldStickToBottom: true,
      isEmbeddedContext: true,
      sessionTag: currentProps.sessionTag,
      agentId: currentProps.agentId,
      initialMessage: currentProps.initialMessage,
      autoSendInitialMessage: (_currentProps$autoSen = currentProps.autoSendInitialMessage) !== null && _currentProps$autoSen !== void 0 ? _currentProps$autoSen : false,
      resetInitialMessage,
      browserApiTools: currentProps.browserApiTools,
      setConversationId,
      attachments: currentProps.attachments,
      resetAttachments,
      removeAttachment,
      conversationActions
    };
  }, [conversationId, currentProps.sessionTag, currentProps.agentId, currentProps.initialMessage, currentProps.autoSendInitialMessage, currentProps.browserApiTools, currentProps.attachments, resetInitialMessage, setConversationId, resetAttachments, removeAttachment, conversationActions]);
  return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: kibanaServices,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_onechat_services_context.OnechatServicesContext.Provider, {
    value: services,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_app_leave_context.AppLeaveContext.Provider, {
    value: noopOnAppLeave,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_conversation_context.ConversationContext.Provider, {
    value: conversationContextValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_agent_builder_tour_context.AgentBuilderTourProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_send_message_context.SendMessageProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 19
    }
  }, children))))))));
};
exports.EmbeddableConversationsProvider = EmbeddableConversationsProvider;