"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TypeSection = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _onechatCommon = require("@kbn/onechat-common");
var _reactHookForm = require("react-hook-form");
var _doc_links = require("../../../../../../common/doc_links");
var _tool_form_section = require("../components/tool_form_section");
var _i18n2 = require("../i18n");
var _use_tool_type_info = require("../../../../hooks/tools/use_tool_type_info");
var _tools_form_registry = require("../registry/tools_form_registry");
var _tool_form = require("../tool_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/form/sections/type.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TECH_PREVIEW_LABEL = _i18n.i18n.translate('xpack.onechat.tools.techPreviewBadgeLabel', {
  defaultMessage: 'Tech preview'
});
const TypeSection = ({
  mode
}) => {
  var _errors$type;
  const {
    formState: {
      errors
    },
    control
  } = (0, _reactHookForm.useFormContext)();
  const type = (0, _reactHookForm.useWatch)({
    control,
    name: 'type'
  });
  const toolConfig = (0, _tools_form_registry.getToolTypeConfig)(type);
  const ConfigurationComponent = (0, _react.useMemo)(() => {
    return toolConfig.getConfigurationComponent();
  }, [toolConfig]);
  const {
    toolTypes: serverToolTypes,
    isLoading: toolTypesLoading
  } = (0, _use_tool_type_info.useToolTypes)();
  const editableToolTypes = (0, _react.useMemo)(() => {
    let editableTypes = (0, _tools_form_registry.getEditableToolTypes)();
    if (!toolTypesLoading && serverToolTypes) {
      const serverEnabledEditableTypes = serverToolTypes.filter(st => st.create).map(st => st.type);
      editableTypes = editableTypes.filter(t => serverEnabledEditableTypes.includes(t.value));
    }
    return editableTypes.map(t => ({
      value: t.value,
      inputDisplay: t.text,
      'data-test-subj': `agentBuilderToolTypeOption-${t.value}`,
      dropdownDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        responsive: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 58,
          columnNumber: 11
        }
      }, t.text), t.value === _onechatCommon.ToolType.mcp && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
        iconType: "flask",
        label: TECH_PREVIEW_LABEL,
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 61,
          columnNumber: 15
        }
      })))
    }));
  }, [serverToolTypes, toolTypesLoading]);
  return /*#__PURE__*/_react.default.createElement(_tool_form_section.ToolFormSection, {
    title: _i18n2.i18nMessages.configuration.documentation.title,
    icon: "code",
    description: _i18n2.i18nMessages.configuration.documentation.description,
    documentation: {
      title: _i18n2.i18nMessages.configuration.documentation.documentationLink,
      href: _doc_links.docLinks.tools
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n2.i18nMessages.configuration.form.type.label,
    error: (_errors$type = errors.type) === null || _errors$type === void 0 ? void 0 : _errors$type.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: "type",
    render: ({
      field: {
        value,
        onChange
      }
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
      "data-test-subj": "agentBuilderToolTypeSelect",
      options: editableToolTypes,
      valueOfSelected: value,
      onChange: onChange,
      disabled: mode === _tool_form.ToolFormMode.Edit,
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(ConfigurationComponent, {
    mode: mode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }));
};
exports.TypeSection = TypeSection;