"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowConfiguration = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _workflow_picker = require("../../components/workflow/workflow_picker");
var _i18n = require("../../i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/form/sections/configuration_fields/workflow_configuration_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const WorkflowConfiguration = () => {
  var _errors$workflow_id, _errors$wait_for_comp;
  const {
    control,
    formState: {
      errors
    }
  } = (0, _reactHookForm.useFormContext)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18nMessages.configuration.form.workflow.workflowLabel,
    isInvalid: !!errors.workflow_id,
    error: (_errors$workflow_id = errors.workflow_id) === null || _errors$workflow_id === void 0 ? void 0 : _errors$workflow_id.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_workflow_picker.WorkflowPicker, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18nMessages.configuration.form.workflow.waitForCompletionLabel,
    helpText: _i18n.i18nMessages.configuration.form.workflow.waitForCompletionHelpText,
    isInvalid: !!errors.wait_for_completion,
    error: (_errors$wait_for_comp = errors.wait_for_completion) === null || _errors$wait_for_comp === void 0 ? void 0 : _errors$wait_for_comp.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: "wait_for_completion",
    render: ({
      field: {
        ref,
        onChange,
        value,
        ...field
      }
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, (0, _extends2.default)({
      id: "agentBuilderWorkflowToolWaitForCompletionCheckbox",
      label: _i18n.i18nMessages.configuration.form.workflow.waitForCompletionCheckboxLabel,
      inputRef: ref,
      onChange: e => {
        onChange(e.target.checked);
      },
      checked: value
    }, field, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 13
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 9
    }
  })));
};
exports.WorkflowConfiguration = WorkflowConfiguration;