"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddMcpServerFlyout = void 0;
var _react = require("react");
var _constants = require("@kbn/connector-schemas/mcp/constants");
var _reactQuery = require("@kbn/react-query");
var _use_kibana = require("../../../../hooks/use_kibana");
var _use_flyout_state = require("../../../../hooks/use_flyout_state");
var _query_keys = require("../../../../query_keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAddMcpServerFlyout = ({
  onConnectorCreated
} = {}) => {
  const {
    services: {
      plugins: {
        triggersActionsUi
      }
    }
  } = (0, _use_kibana.useKibana)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    openFlyout,
    closeFlyout,
    isOpen
  } = (0, _use_flyout_state.useFlyoutState)();

  // Refresh the list of MCP connectors when a new MCP connector is created
  const handleConnectorCreated = (0, _react.useCallback)(connector => {
    queryClient.invalidateQueries({
      queryKey: _query_keys.queryKeys.tools.connectors.list(_constants.CONNECTOR_ID)
    });
    onConnectorCreated === null || onConnectorCreated === void 0 ? void 0 : onConnectorCreated(connector);
  }, [queryClient, onConnectorCreated]);
  const flyout = (0, _react.useMemo)(() => triggersActionsUi.getAddConnectorFlyout({
    onClose: closeFlyout,
    onConnectorCreated: handleConnectorCreated,
    initialConnector: {
      actionTypeId: _constants.CONNECTOR_ID
    }
  }), [closeFlyout, handleConnectorCreated, triggersActionsUi]);
  return {
    openFlyout,
    closeFlyout,
    isOpen,
    flyout
  };
};
exports.useAddMcpServerFlyout = useAddMcpServerFlyout;