"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.McpHealthBanner = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireDefault(require("react"));
var _mcp = require("../../types/mcp");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/form/components/mcp/mcp_health_banner.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const mcpHealthI18nMessages = {
  toolNotFound: {
    title: _i18n.i18n.translate('xpack.onechat.tools.mcpHealthBanner.toolNotFound.title', {
      defaultMessage: 'Tool not found on MCP server'
    }),
    description: _i18n.i18n.translate('xpack.onechat.tools.mcpHealthBanner.toolNotFound.description', {
      defaultMessage: 'The tool below no longer exists on the selected MCP server. It may have been removed or renamed.'
    })
  },
  connectorNotFound: {
    title: _i18n.i18n.translate('xpack.onechat.tools.mcpHealthBanner.connectorNotFound.title', {
      defaultMessage: 'MCP connector unavailable'
    }),
    description: _i18n.i18n.translate('xpack.onechat.tools.mcpHealthBanner.connectorNotFound.description', {
      defaultMessage: 'The MCP connector used by this tool is no longer available. Please create a new tool.'
    })
  },
  listToolsFailed: {
    title: _i18n.i18n.translate('xpack.onechat.tools.mcpHealthBanner.listToolsFailed.title', {
      defaultMessage: "Can't retrieve tools from MCP server"
    }),
    description: _i18n.i18n.translate('xpack.onechat.tools.mcpHealthBanner.listToolsFailed.description', {
      defaultMessage: "We're unable to fetch tools from this MCP server. This is usually caused by a connection or configuration issue with the MCP connector."
    })
  },
  toolUnhealthy: {
    title: _i18n.i18n.translate('xpack.onechat.tools.mcpHealthBanner.toolUnhealthy.title', {
      defaultMessage: 'Tool execution failed'
    }),
    description: _i18n.i18n.translate('xpack.onechat.tools.mcpHealthBanner.toolUnhealthy.description', {
      defaultMessage: 'This tool encountered an error while running in Agent Builder. Please verify the MCP connector configuration and try again.'
    })
  },
  deleteToolButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.mcpHealthBanner.deleteToolButtonLabel', {
    defaultMessage: 'Delete this tool'
  }),
  createNewToolButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.mcpHealthBanner.createNewToolButtonLabel', {
    defaultMessage: 'Create a new tool'
  }),
  viewConnectorsButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.mcpHealthBanner.viewConnectorsButtonLabel', {
    defaultMessage: 'View connectors'
  }),
  viewMcpServerButtonLabel: _i18n.i18n.translate('xpack.onechat.tools.mcpHealthBanner.viewMcpServerButtonLabel', {
    defaultMessage: 'View MCP server'
  })
};
const healthStatusMessages = {
  [_mcp.McpToolHealthStatus.ToolNotFound]: {
    title: mcpHealthI18nMessages.toolNotFound.title,
    description: mcpHealthI18nMessages.toolNotFound.description
  },
  [_mcp.McpToolHealthStatus.ConnectorNotFound]: {
    title: mcpHealthI18nMessages.connectorNotFound.title,
    description: mcpHealthI18nMessages.connectorNotFound.description
  },
  [_mcp.McpToolHealthStatus.ListToolsFailed]: {
    title: mcpHealthI18nMessages.listToolsFailed.title,
    description: mcpHealthI18nMessages.listToolsFailed.description
  },
  [_mcp.McpToolHealthStatus.ToolUnhealthy]: {
    title: mcpHealthI18nMessages.toolUnhealthy.title,
    description: mcpHealthI18nMessages.toolUnhealthy.description
  }
};
const McpHealthBanner = ({
  status,
  onCreateNewTool,
  onDeleteTool,
  onViewConnectors,
  onViewMcpServer
}) => {
  const deleteToolButton = {
    label: mcpHealthI18nMessages.deleteToolButtonLabel,
    iconType: 'trash',
    onClick: onDeleteTool
  };
  const createNewToolButton = {
    label: mcpHealthI18nMessages.createNewToolButtonLabel,
    iconType: 'plus',
    onClick: onCreateNewTool
  };
  const viewConnectorsButton = {
    label: mcpHealthI18nMessages.viewConnectorsButtonLabel,
    iconType: 'eye',
    onClick: onViewConnectors
  };
  const viewMcpServerButton = {
    label: mcpHealthI18nMessages.viewMcpServerButtonLabel,
    iconType: 'eye',
    onClick: onViewMcpServer
  };
  const healthStatusButtons = {
    [_mcp.McpToolHealthStatus.ToolNotFound]: [deleteToolButton, createNewToolButton],
    [_mcp.McpToolHealthStatus.ConnectorNotFound]: [deleteToolButton, viewConnectorsButton],
    [_mcp.McpToolHealthStatus.ListToolsFailed]: [viewMcpServerButton],
    [_mcp.McpToolHealthStatus.ToolUnhealthy]: [viewMcpServerButton]
  };
  if (status === _mcp.McpToolHealthStatus.Healthy) {
    return null;
  }
  const {
    title,
    description
  } = healthStatusMessages[status];
  const iconType = _mcp.mcpUnhealthyStatusIconMap[status];
  const actionButtons = healthStatusButtons[status].filter(button => button.onClick);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiCallOut, {
    title: title,
    iconType: iconType,
    color: "danger",
    css: ({
      euiTheme
    }) => (0, _react.css)`
        margin-block-end: ${euiTheme.size.l};
      `,
    announceOnMount: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 7
    }
  }, description), actionButtons.length > 0 && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 11
    }
  }, actionButtons.map((button, index) => /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    key: button.label,
    color: "danger",
    size: "s",
    iconType: button.iconType,
    onClick: button.onClick,
    fill: index === 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 15
    }
  }, button.label)))));
};
exports.McpHealthBanner = McpHealthBanner;