"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.McpEditableFields = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _constants = require("@kbn/connector-schemas/mcp/constants");
var _react2 = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _use_mcp_connectors = require("../../../../../hooks/tools/use_mcp_connectors");
var _use_navigation = require("../../../../../hooks/use_navigation");
var _app_paths = require("../../../../../utils/app_paths");
var _truncate_at_sentence = require("../../../../../utils/truncate_at_sentence");
var _use_add_mcp_server_flyout = require("../../hooks/use_add_mcp_server_flyout");
var _use_edit_mcp_server_flyout = require("../../hooks/use_edit_mcp_server_flyout");
var _i18n = require("../../i18n");
var _mcp = require("../../types/mcp");
var _mcp_health_banner = require("./mcp_health_banner");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/form/components/mcp/mcp_editable_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const mcpActionLinkStyles = euiThemeContext => (0, _react.css)`
  font-size: ${(0, _eui.euiFontSize)(euiThemeContext, 'xs').fontSize};
  font-weight: ${euiThemeContext.euiTheme.font.weight.semiBold};
`;
const McpEditableFields = ({
  mcpHealthStatus,
  setMcpHealthStatus
}) => {
  var _errors$connectorId, _errors$mcpToolName;
  const euiThemeContext = (0, _eui.useEuiTheme)();
  const {
    navigateToOnechatUrl
  } = (0, _use_navigation.useNavigation)();
  const {
    control,
    formState: {
      errors
    },
    clearErrors,
    setValue
  } = (0, _reactHookForm.useFormContext)();
  const handleConnectorCreated = (0, _react2.useCallback)(connector => {
    setValue('connectorId', connector.id, {
      shouldValidate: true
    });
  }, [setValue]);
  const {
    openFlyout: openCreateMcpServerFlyout,
    isOpen: isCreateMcpServerFlyoutOpen,
    flyout: createMcpServerFlyout
  } = (0, _use_add_mcp_server_flyout.useAddMcpServerFlyout)({
    onConnectorCreated: handleConnectorCreated
  });
  const handleBulkImportClick = (0, _react2.useCallback)(() => {
    navigateToOnechatUrl(_app_paths.appPaths.tools.bulkImportMcp);
  }, [navigateToOnechatUrl]);
  const {
    connectors,
    isLoading: isLoadingConnectors
  } = (0, _use_mcp_connectors.useListConnectors)({
    type: _constants.CONNECTOR_ID
  });
  const connectorId = (0, _reactHookForm.useWatch)({
    control,
    name: 'connectorId'
  });
  const {
    mcpTools,
    isLoading: isLoadingMcpTools,
    isError: isErrorMcpTools
  } = (0, _use_mcp_connectors.useListMcpTools)({
    connectorId
  });
  const selectedConnector = (0, _react2.useMemo)(() => connectors.find(connector => connector.id === connectorId), [connectors, connectorId]);
  const {
    openFlyout: openEditMcpServerFlyout,
    isOpen: isEditMcpServerFlyoutOpen,
    flyout: editMcpServerFlyout
  } = (0, _use_edit_mcp_server_flyout.useEditMcpServerFlyout)({
    connector: selectedConnector
  });
  (0, _react2.useEffect)(() => {
    if (isLoadingMcpTools) {
      return;
    }
    if (isErrorMcpTools) {
      setMcpHealthStatus(_mcp.McpToolHealthStatus.ListToolsFailed);
      return;
    }
    setMcpHealthStatus(_mcp.McpToolHealthStatus.Healthy);
  }, [isLoadingMcpTools, isErrorMcpTools, setMcpHealthStatus]);

  // Clear the MCP tool, error state, and tool fields when the connector changes
  (0, _eui.useUpdateEffect)(() => {
    setValue('mcpToolName', '');
    setValue('toolId', '');
    setValue('description', '');
    clearErrors('mcpToolName');
  }, [connectorId]);
  const connectorOptions = (0, _react2.useMemo)(() => connectors.map(connector => ({
    label: connector.name,
    value: connector.id
  })), [connectors]);
  const mcpToolOptions = (0, _react2.useMemo)(() => {
    return mcpTools.map(mcpTool => ({
      label: mcpTool.name,
      value: {
        ...mcpTool,
        shortDescription: (0, _truncate_at_sentence.truncateAtSentence)(mcpTool.description)
      }
    }));
  }, [mcpTools]);
  const renderMcpToolOption = (0, _react2.useCallback)((option, searchValue, contentClassName) => {
    var _option$value;
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "xs",
      className: contentClassName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react2.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiHighlight, {
      search: searchValue,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 15
      }
    }, option.label))), ((_option$value = option.value) === null || _option$value === void 0 ? void 0 : _option$value.shortDescription) && /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiHighlight, {
      search: searchValue,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 15
      }
    }, option.value.shortDescription)));
  }, []);
  const isMcpToolsDisabled = !connectorId || isLoadingMcpTools || mcpHealthStatus !== _mcp.McpToolHealthStatus.Healthy;
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, mcpHealthStatus && /*#__PURE__*/_react2.default.createElement(_mcp_health_banner.McpHealthBanner, {
    status: mcpHealthStatus,
    onViewMcpServer: openEditMcpServerFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18nMessages.configuration.form.mcp.connectorLabel,
    isInvalid: !!errors.connectorId,
    error: (_errors$connectorId = errors.connectorId) === null || _errors$connectorId === void 0 ? void 0 : _errors$connectorId.message,
    labelAppend: /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
      onClick: openCreateMcpServerFlyout,
      css: mcpActionLinkStyles(euiThemeContext),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 13
      }
    }, _i18n.i18nMessages.configuration.form.mcp.addMcpServerButtonLabel),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: "connectorId",
    render: ({
      field: {
        value,
        onChange,
        onBlur,
        ref,
        ...field
      }
    }) => /*#__PURE__*/_react2.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
      isInvalid: !!errors.connectorId,
      fullWidth: true,
      singleSelection: {
        asPlainText: true
      },
      options: connectorOptions,
      selectedOptions: connectorOptions.filter(connector => connector.value === value),
      onChange: selectedOptions => {
        const [selectedConnectorOption] = selectedOptions;
        onChange(selectedConnectorOption.value);
        onBlur();
      },
      isLoading: isLoadingConnectors,
      inputRef: ref,
      isClearable: false,
      onBlur: onBlur
    }, field, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 15
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18nMessages.configuration.form.mcp.mcpToolLabel,
    isInvalid: !!errors.mcpToolName,
    error: (_errors$mcpToolName = errors.mcpToolName) === null || _errors$mcpToolName === void 0 ? void 0 : _errors$mcpToolName.message,
    labelAppend: /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
      onClick: handleBulkImportClick,
      css: mcpActionLinkStyles(euiThemeContext),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 13
      }
    }, _i18n.i18nMessages.configuration.form.mcp.bulkImportMcpToolsButtonLabel),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: "mcpToolName",
    render: ({
      field: {
        value,
        onChange,
        onBlur,
        ref,
        ...field
      }
    }) => /*#__PURE__*/_react2.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
      isInvalid: !!errors.mcpToolName,
      fullWidth: true,
      singleSelection: {
        asPlainText: true
      },
      options: mcpToolOptions,
      selectedOptions: value ? mcpToolOptions.filter(option => {
        var _option$value2;
        return ((_option$value2 = option.value) === null || _option$value2 === void 0 ? void 0 : _option$value2.name) === value;
      }) : [],
      onChange: selectedOptions => {
        var _selectedMcpTool$valu;
        const [selectedMcpTool] = selectedOptions;
        onChange((_selectedMcpTool$valu = selectedMcpTool.value) === null || _selectedMcpTool$valu === void 0 ? void 0 : _selectedMcpTool$valu.name);
        onBlur();

        // Update the tool ID and description
        if (selectedMcpTool.value) {
          const {
            name,
            description = ''
          } = selectedMcpTool.value;
          setValue('toolId', name, {
            shouldValidate: true
          });
          setValue('description', description, {
            shouldValidate: true
          });
        }
      },
      isLoading: !!connectorId && isLoadingMcpTools,
      isDisabled: isMcpToolsDisabled,
      inputRef: ref,
      isClearable: false,
      renderOption: renderMcpToolOption,
      rowHeight: "auto"
    }, !isMcpToolsDisabled ? {
      onBlur
    } : {}, field, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 226,
        columnNumber: 15
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 11
    }
  }))), isCreateMcpServerFlyoutOpen && createMcpServerFlyout, isEditMcpServerFlyoutOpen && editMcpServerFlyout);
};
exports.McpEditableFields = McpEditableFields;