"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsqlParams = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _esqlUtils = require("@kbn/esql-utils");
var _fieldTypes = require("@kbn/field-types");
var _lodash = require("lodash");
var _react2 = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _use_esql_editor_params = require("../../hooks/use_esql_editor_params");
var _use_esql_params_validation = require("../../hooks/use_esql_params_validation");
var _i18n = require("../../i18n");
var _tool_form_types = require("../../types/tool_form_types");
var _esql_param_row = require("./esql_param_row");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/form/components/esql/esql_params.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EsqlParamActions = ({
  onAppend,
  onReplace
}) => {
  const {
    trigger,
    getValues,
    setFocus
  } = (0, _reactHookForm.useFormContext)();
  const {
    triggerEsqlParamWarnings,
    triggerEsqlParamFieldsValidation
  } = (0, _use_esql_params_validation.useEsqlParamsValidation)();
  const inferParamsFromEsql = (0, _react2.useCallback)(() => {
    const inferredParamNamesFromEsql = (0, _esqlUtils.getESQLQueryVariables)(getValues('esql'));
    const existingParamsNameMap = getValues('params').reduce((paramNamesMap, param) => {
      if (!paramNamesMap[param.name]) {
        paramNamesMap[param.name] = param;
      }
      return paramNamesMap;
    }, {});
    const updatedParams = [...new Set(inferredParamNamesFromEsql)].map(inferredParamName => {
      return existingParamsNameMap[inferredParamName] ? {
        ...existingParamsNameMap[inferredParamName],
        source: _tool_form_types.EsqlParamSource.Inferred
      } : {
        name: inferredParamName,
        description: '',
        type: _fieldTypes.ES_FIELD_TYPES.TEXT,
        source: _tool_form_types.EsqlParamSource.Inferred,
        optional: false
      };
    });
    onReplace(updatedParams);

    // Scroll into view
    (0, _lodash.defer)(() => setFocus(`params.${updatedParams.length - 1}.name`));
    triggerEsqlParamWarnings();
  }, [getValues, onReplace, triggerEsqlParamWarnings, setFocus]);
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _i18n.i18nMessages.inferParamsButtonLabel,
    iconType: "sparkles",
    color: "primary",
    size: "s",
    onClick: () => {
      inferParamsFromEsql();
      trigger('esql');
      triggerEsqlParamFieldsValidation(['name']);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, _i18n.i18nMessages.inferParamsButtonLabel)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _i18n.i18nMessages.addParamButtonLabel,
    iconType: "plusInCircle",
    color: "primary",
    size: "s",
    onClick: () => {
      triggerEsqlParamFieldsValidation(['name', 'description', 'type']);
      onAppend();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, _i18n.i18nMessages.addParamButtonLabel)));
};
const EsqlParamsLayout = ({
  actions,
  fields
}) => {
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  if (!fields) {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: isMobile ? 's' : 'm',
      justifyContent: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 7
      }
    }, actions);
  }
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 7
    }
  }, fields), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 9
    }
  }, actions)));
};
const EsqlParams = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    control
  } = (0, _reactHookForm.useFormContext)();
  const {
    fields: paramFields,
    append: appendParamField,
    remove: removeParamField,
    replace: replaceParamFields
  } = (0, _reactHookForm.useFieldArray)({
    control,
    name: 'params'
  });
  const params = (0, _reactHookForm.useWatch)({
    control,
    name: 'params'
  });
  const handleAppend = (0, _react2.useCallback)(name => {
    appendParamField({
      name: name !== null && name !== void 0 ? name : '',
      description: '',
      type: _fieldTypes.ES_FIELD_TYPES.TEXT,
      source: _tool_form_types.EsqlParamSource.Custom,
      optional: false
    });
  }, [appendParamField]);
  const handleReplace = (0, _react2.useCallback)(nextParams => {
    replaceParamFields(nextParams);
  }, [replaceParamFields]);
  (0, _use_esql_editor_params.useEsqlEditorParams)({
    params,
    addParam: handleAppend
  });
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(EsqlParamsLayout, {
    actions: /*#__PURE__*/_react2.default.createElement(EsqlParamActions, {
      onAppend: handleAppend,
      onReplace: handleReplace,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 18
      }
    }),
    fields: paramFields.length > 0 && /*#__PURE__*/_react2.default.createElement("div", {
      css: (0, _react.css)`
                background-color: ${euiTheme.colors.backgroundBaseSubdued};
                border-radius: ${euiTheme.border.radius.medium};
                padding: ${euiTheme.size.s};

                .euiTable {
                  background-color: ${euiTheme.colors.backgroundBaseSubdued};
                }
              `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTable, {
      compressed: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTableHeader, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTableHeaderCell, {
      width: "24px",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 19
      }
    }), /*#__PURE__*/_react2.default.createElement(_eui.EuiTableHeaderCell, {
      width: "25%",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 19
      }
    }, _i18n.i18nMessages.paramNameLabel), /*#__PURE__*/_react2.default.createElement(_eui.EuiTableHeaderCell, {
      width: "50%",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 19
      }
    }, _i18n.i18nMessages.paramDescriptionLabel), /*#__PURE__*/_react2.default.createElement(_eui.EuiTableHeaderCell, {
      width: "128px",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 19
      }
    }, _i18n.i18nMessages.paramTypeLabel), /*#__PURE__*/_react2.default.createElement(_eui.EuiTableHeaderCell, {
      width: "64px",
      align: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 19
      }
    }, _i18n.i18nMessages.optionalParamLabel), /*#__PURE__*/_react2.default.createElement(_eui.EuiTableHeaderCell, {
      width: "36px",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 211,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react2.default.createElement(_eui.EuiTableBody, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 213,
        columnNumber: 17
      }
    }, paramFields.map((paramField, index) => /*#__PURE__*/_react2.default.createElement(_esql_param_row.EsqlParamRow, {
      key: paramField.id,
      index: index,
      paramField: paramField,
      removeParamField: removeParamField,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 21
      }
    }))))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 7
    }
  }));
};
exports.EsqlParams = EsqlParams;