"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMcpToolsSearch = void 0;
var _eui = require("@elastic/eui");
var _react = require("react");
var _i18n = require("../../../utils/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMcpToolsSearch = ({
  tools,
  isDisabled = false
}) => {
  const [searchQuery, setSearchQuery] = (0, _react.useState)('');
  const [results, setResults] = (0, _react.useState)([...tools]);
  (0, _react.useEffect)(() => {
    setResults([...tools]);
  }, [tools]);
  const handleChange = (0, _react.useCallback)(({
    query,
    queryText,
    error: searchError
  }) => {
    if (searchError) {
      return;
    }
    const newItems = query ? _eui.EuiSearchBar.Query.execute(query, tools, {
      defaultFields: ['name', 'description']
    }) : [...tools];
    setSearchQuery(queryText);
    setResults(newItems);
  }, [tools]);
  const searchConfig = (0, _react.useMemo)(() => ({
    onChange: handleChange,
    box: {
      incremental: true,
      placeholder: _i18n.labels.tools.bulkImportMcp.sourceSection.searchPlaceholder,
      disabled: isDisabled || tools.length === 0,
      'data-test-subj': 'bulkImportMcpToolsSearchInput'
    }
  }), [handleChange, isDisabled, tools.length]);
  return {
    searchConfig,
    searchQuery,
    results
  };
};
exports.useMcpToolsSearch = useMcpToolsSearch;