"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceSection = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _constants = require("@kbn/connector-schemas/mcp/constants");
var _reactHookForm = require("react-hook-form");
var _use_mcp_connectors = require("../../../../hooks/tools/use_mcp_connectors");
var _i18n = require("../../../../utils/i18n");
var _tool_form_section = require("../../form/components/tool_form_section");
var _use_add_mcp_server_flyout = require("../../form/hooks/use_add_mcp_server_flyout");
var _mcp_tools_selection_table = require("../mcp_tools_selection_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/bulk_import/sections/source.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const mcpActionLinkStyles = euiThemeContext => (0, _react2.css)`
  font-size: ${(0, _eui.euiFontSize)(euiThemeContext, 'xs').fontSize};
  font-weight: ${euiThemeContext.euiTheme.font.weight.semiBold};
`;
const SourceSection = () => {
  var _errors$connectorId, _errors$tools;
  const euiThemeContext = (0, _eui.useEuiTheme)();
  const {
    control,
    formState,
    setValue,
    trigger,
    getFieldState
  } = (0, _reactHookForm.useFormContext)();
  const {
    errors
  } = formState;
  const handleConnectorCreated = (0, _react.useCallback)(connector => {
    setValue('connectorId', connector.id, {
      shouldValidate: true
    });
    // Clear tool selection when connector changes
    setValue('tools', []);
  }, [setValue]);
  const {
    openFlyout: openCreateMcpServerFlyout,
    isOpen: isCreateMcpServerFlyoutOpen,
    flyout: createMcpServerFlyout
  } = (0, _use_add_mcp_server_flyout.useAddMcpServerFlyout)({
    onConnectorCreated: handleConnectorCreated
  });
  const {
    connectors,
    isLoading: isLoadingConnectors
  } = (0, _use_mcp_connectors.useListConnectors)({
    type: _constants.CONNECTOR_ID
  });
  const connectorId = (0, _reactHookForm.useWatch)({
    control,
    name: 'connectorId'
  });
  const selectedTools = (0, _reactHookForm.useWatch)({
    control,
    name: 'tools'
  });
  const {
    mcpTools,
    isLoading: isLoadingMcpTools,
    isError: isErrorMcpTools
  } = (0, _use_mcp_connectors.useListMcpTools)({
    connectorId
  });
  const connectorOptions = (0, _react.useMemo)(() => connectors.map(connector => ({
    label: connector.name,
    value: connector.id
  })), [connectors]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_tool_form_section.ToolFormSection, {
    title: _i18n.labels.tools.bulkImportMcp.sourceSection.title,
    icon: "download",
    description: _i18n.labels.tools.bulkImportMcp.sourceSection.description,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.labels.tools.bulkImportMcp.sourceSection.mcpServerLabel,
    isInvalid: !!errors.connectorId,
    error: (_errors$connectorId = errors.connectorId) === null || _errors$connectorId === void 0 ? void 0 : _errors$connectorId.message,
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: openCreateMcpServerFlyout,
      css: mcpActionLinkStyles(euiThemeContext),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 13
      }
    }, _i18n.labels.tools.bulkImportMcp.sourceSection.addMcpServerLink),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: "connectorId",
    render: ({
      field: {
        value,
        onChange,
        onBlur,
        ref,
        ...field
      }
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
      isInvalid: !!errors.connectorId,
      fullWidth: true,
      singleSelection: {
        asPlainText: true
      },
      options: connectorOptions,
      selectedOptions: connectorOptions.filter(connector => connector.value === value),
      onChange: selectedOptions => {
        const [selectedConnectorOption] = selectedOptions;
        onChange(selectedConnectorOption.value);
        onBlur();
        // Clear tool selection when connector changes
        setValue('tools', []);
        if (getFieldState('namespace').isDirty) {
          trigger('namespace');
        }
      },
      isLoading: isLoadingConnectors,
      inputRef: ref,
      isClearable: false,
      onBlur: onBlur
    }, field, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 15
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.labels.tools.bulkImportMcp.sourceSection.toolsToImportLabel,
    fullWidth: true,
    isInvalid: !!errors.tools,
    error: (_errors$tools = errors.tools) === null || _errors$tools === void 0 ? void 0 : _errors$tools.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: "tools",
    render: ({
      field: {
        onChange
      }
    }) => /*#__PURE__*/_react.default.createElement(_mcp_tools_selection_table.McpToolsSelectionTable, {
      tools: mcpTools,
      selectedTools: selectedTools,
      onChange: tools => {
        onChange(tools.map(tool => ({
          name: tool.name,
          description: tool.description
        })));
      },
      isLoading: isLoadingMcpTools && !!connectorId,
      isError: isErrorMcpTools,
      isDisabled: !connectorId,
      disabledMessage: _i18n.labels.tools.bulkImportMcp.sourceSection.selectMcpServerMessage,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 11
    }
  }))), isCreateMcpServerFlyoutOpen && createMcpServerFlyout);
};
exports.SourceSection = SourceSection;