"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteConversationModal = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _conversation_context = require("../../context/conversation/conversation_context");
var _use_conversation_id = require("../../context/conversation/use_conversation_id");
var _use_conversation = require("../../hooks/use_conversation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/delete_conversation_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DeleteConversationModal = ({
  isOpen,
  onClose,
  conversation
}) => {
  var _conversation$id, _conversation$title;
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const currentConversationId = (0, _use_conversation_id.useConversationId)();
  const {
    title: currentTitle
  } = (0, _use_conversation.useConversationTitle)();
  const conversationId = (_conversation$id = conversation === null || conversation === void 0 ? void 0 : conversation.id) !== null && _conversation$id !== void 0 ? _conversation$id : currentConversationId;
  const title = (_conversation$title = conversation === null || conversation === void 0 ? void 0 : conversation.title) !== null && _conversation$title !== void 0 ? _conversation$title : currentTitle;
  const {
    conversationActions
  } = (0, _conversation_context.useConversationContext)();
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'deleteConversationModal'
  });
  const handleDelete = (0, _react.useCallback)(async () => {
    if (!conversationId) {
      return;
    }
    setIsLoading(true);
    await conversationActions.deleteConversation(conversationId);
    setIsLoading(false);
    onClose();
  }, [conversationId, conversationActions, onClose]);
  if (!isOpen || !conversationId) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    maxWidth: "400px",
    "aria-labelledby": confirmModalTitleId,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.conversationTitle.deleteConversationModal.title",
      defaultMessage: "Delete conversation",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 9
      }
    }),
    titleProps: {
      id: confirmModalTitleId
    },
    onCancel: onClose,
    onConfirm: handleDelete,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.conversationTitle.deleteConversationModal.cancelButton",
      defaultMessage: "Cancel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 9
      }
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.conversationTitle.deleteConversationModal.confirmButton",
      defaultMessage: "Delete",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 9
      }
    }),
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.conversationTitle.deleteConversationModal.description",
    defaultMessage: "Are you sure you want to delete the conversation {title}? This action cannot be undone.",
    values: {
      title: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 20
        }
      }, title || '')
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  })));
};
exports.DeleteConversationModal = DeleteConversationModal;