"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationHistoryList = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _conversation_context = require("../../../context/conversation/conversation_context");
var _use_conversation_id = require("../../../context/conversation/use_conversation_id");
var _use_conversation_list = require("../../../hooks/use_conversation_list");
var _use_navigation = require("../../../hooks/use_navigation");
var _app_paths = require("../../../utils/app_paths");
var _group_conversations = require("../../../utils/group_conversations");
var _no_conversations_prompt = require("./no_conversations_prompt");
var _delete_conversation_modal = require("../delete_conversation_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversations_history/conversations_history_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EMPTY_CONTAINER_HEIGHT = 300;
const ROW_HEIGHT = 32;
const MAX_ROWS = 18;
const MAX_LIST_HEIGHT = ROW_HEIGHT * MAX_ROWS;
const emptyContainerStyles = (0, _react.css)`
  height: ${EMPTY_CONTAINER_HEIGHT}px;
  justify-content: center;
  align-items: center;
`;
const deleteConversationLabel = title => _i18n.i18n.translate('xpack.onechat.conversationsHistory.deleteConversation', {
  defaultMessage: 'Delete conversation {title}',
  values: {
    title
  }
});
const ConversationHistoryList = ({
  onClose
}) => {
  const {
    conversations = [],
    isLoading
  } = (0, _use_conversation_list.useConversationList)();
  const currentConversationId = (0, _use_conversation_id.useConversationId)();
  const {
    navigateToOnechatUrl
  } = (0, _use_navigation.useNavigation)();
  const {
    isEmbeddedContext,
    setConversationId
  } = (0, _conversation_context.useConversationContext)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [conversationToDelete, setConversationToDelete] = (0, _react2.useState)(null);
  const timeSections = (0, _react2.useMemo)(() => {
    if (!conversations || conversations.length === 0) {
      return [];
    }
    return (0, _group_conversations.groupConversationsByTime)(conversations);
  }, [conversations]);
  const selectableOptions = (0, _react2.useMemo)(() => {
    const options = [];
    timeSections.forEach(({
      label,
      conversations: sectionConversations
    }) => {
      // Add group label
      options.push({
        label,
        isGroupLabel: true
      });

      // Add conversation options
      sectionConversations.forEach(conversation => {
        options.push({
          key: conversation.id,
          label: conversation.title,
          checked: currentConversationId === conversation.id ? 'on' : undefined,
          'data-test-subj': `conversationItem-${conversation.id}`,
          append: /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
            iconType: "trash",
            color: "danger",
            "aria-label": deleteConversationLabel(conversation.title),
            onClick: event => {
              // Must stop click event from propagating to list item which would trigger navigation
              event.stopPropagation();
              setConversationToDelete(conversation);
            },
            "data-test-subj": `deleteConversationButton-${conversation.id}`,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 86,
              columnNumber: 13
            }
          }),
          data: {
            conversation
          }
        });
      });
    });
    return options;
  }, [timeSections, currentConversationId]);
  const handleChange = (0, _react2.useCallback)((_options, _event, changedOption) => {
    var _changedOption$data;
    if (!(changedOption !== null && changedOption !== void 0 && (_changedOption$data = changedOption.data) !== null && _changedOption$data !== void 0 && _changedOption$data.conversation)) return;
    const conversation = changedOption.data.conversation;
    if (isEmbeddedContext) {
      setConversationId === null || setConversationId === void 0 ? void 0 : setConversationId(conversation.id);
    } else {
      navigateToOnechatUrl(_app_paths.appPaths.chat.conversation({
        conversationId: conversation.id
      }));
    }
    onClose === null || onClose === void 0 ? void 0 : onClose();
  }, [isEmbeddedContext, onClose, setConversationId, navigateToOnechatUrl]);
  if (isLoading) {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      css: emptyContainerStyles,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 9
      }
    }));
  }
  if (timeSections.length === 0) {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      css: emptyContainerStyles,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(_no_conversations_prompt.NoConversationsPrompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 9
      }
    }));
  }

  // remove borders from list items and group labels
  const listStylesOverride = (0, _react.css)`
    .euiSelectableListItem:not(:last-of-type) {
      border-block-end: 0;
    }
    .euiSelectableList__groupLabel {
      border-block-end: 0;
      :not(:first-of-type) {
        padding-block-start: ${euiTheme.size.m};
      }
    }
    /* Only show append icon on hover or focus */
    .euiSelectableListItem__append {
      opacity: 0;
    }
    .euiSelectableListItem:hover .euiSelectableListItem__append,
    .euiSelectableListItem-isFocused .euiSelectableListItem__append {
      opacity: 1;
    }
  `;
  const listItemsHeight = selectableOptions.length * ROW_HEIGHT;
  // Calculate height based on item count, capped at max rows
  const listHeight = Math.min(listItemsHeight, MAX_LIST_HEIGHT);
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSelectable, {
    height: listHeight,
    searchable: true,
    searchProps: {
      placeholder: _i18n.i18n.translate('xpack.onechat.conversationsHistory.searchPlaceholder', {
        defaultMessage: 'Search conversations'
      }),
      compressed: true,
      inputRef: node => {
        node === null || node === void 0 ? void 0 : node.focus();
      }
    },
    options: selectableOptions,
    onChange: handleChange,
    singleSelection: true,
    "aria-label": _i18n.i18n.translate('xpack.onechat.conversationsHistory.conversations', {
      defaultMessage: 'Conversations'
    }),
    "data-test-subj": "agentBuilderConversationList",
    listProps: {
      bordered: false,
      showIcons: false,
      onFocusBadge: false
    },
    css: listStylesOverride,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 7
    }
  }, (list, search) => /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 13
    }
  }, search), list)), /*#__PURE__*/_react2.default.createElement(_delete_conversation_modal.DeleteConversationModal, {
    isOpen: conversationToDelete !== null,
    onClose: () => {
      setConversationToDelete(null);
    },
    conversation: conversationToDelete !== null && conversationToDelete !== void 0 ? conversationToDelete : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 7
    }
  }));
};
exports.ConversationHistoryList = ConversationHistoryList;