"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolCallDisplay = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _use_navigation = require("../../../../../hooks/use_navigation");
var _app_paths = require("../../../../../utils/app_paths");
var _thinking_item_layout = require("./thinking_item_layout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/round_thinking/steps/tool_call_display.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const labels = {
  toolCall: _i18n.i18n.translate('xpack.onechat.thinking.toolCallLabel', {
    defaultMessage: 'Tool call'
  }),
  toolLink: _i18n.i18n.translate('xpack.onechat.thinking.toolLinkLabel', {
    defaultMessage: 'View tool details'
  })
};
const ToolCallDisplay = ({
  step,
  icon,
  textColor
}) => {
  const {
    tool_id: toolId
  } = step;
  const {
    createOnechatUrl
  } = (0, _use_navigation.useNavigation)();
  const toolHref = createOnechatUrl(_app_paths.appPaths.tools.details({
    toolId
  }));
  const toolLinkId = `tool-link-${toolId}`;
  return /*#__PURE__*/_react.default.createElement(_thinking_item_layout.ThinkingItemLayout, {
    icon: icon,
    accordionContent: step.params,
    textColor: textColor,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    role: "status",
    "aria-label": labels.toolCall,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.thinking.toolCallThinkingItem",
    defaultMessage: "Calling tool {tool}",
    values: {
      tool: /*#__PURE__*/_react.default.createElement("code", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: toolHref,
        target: "_blank",
        id: toolLinkId,
        "aria-label": `${labels.toolLink} ${toolId}`,
        rel: "noopener noreferrer",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 19
        }
      }, toolId))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 11
    }
  }))));
};
exports.ToolCallDisplay = ToolCallDisplay;