"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.esqlLanguagePlugin = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const esqlLanguagePlugin = () => {
  const visitor = (node, parent) => {
    if ('children' in node) {
      const nodeAsParent = node;
      nodeAsParent.children.forEach(child => {
        visitor(child, nodeAsParent);
      });
    }
    if (node.type === 'code' && node.lang === 'esql') {
      node.type = 'esql';
    } else if (node.type === 'code') {
      // switch to type that allows us to control rendering
      node.type = 'codeBlock';
    }
  };
  return tree => {
    visitor(tree);
  };
};
exports.esqlLanguagePlugin = esqlLanguagePlugin;