"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDashboardRenderer = createDashboardRenderer;
exports.dashboardTagParser = void 0;
var _css = require("@emotion/css");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _tool_result = require("@kbn/onechat-common/tools/tool_result");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/round_response/markdown_plugins/dashboard_plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const dashboardTagParser = exports.dashboardTagParser = (0, _utils.createTagParser)({
  tagName: _tool_result.dashboardElement.tagName,
  getAttributes: (value, extractAttr) => ({
    toolResultId: extractAttr(value, _tool_result.dashboardElement.attributes.toolResultId)
  }),
  assignAttributes: (node, attributes) => {
    node.type = _tool_result.dashboardElement.tagName;
    node.toolResultId = attributes.toolResultId;
    delete node.value;
  },
  createNode: (attributes, position) => ({
    type: _tool_result.dashboardElement.tagName,
    toolResultId: attributes.toolResultId,
    position
  })
});
const DashboardCard = ({
  title,
  url
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const iconContainerStyles = (0, _css.css)`
    display: flex;
    align-items: center;
    justify-content: center;
    width: ${euiTheme.size.xxl};
    height: ${euiTheme.size.xxl};
    border-radius: ${euiTheme.border.radius.medium};
    background-color: ${euiTheme.colors.primary};
  `;
  const panelStyles = (0, _css.css)`
    border: ${euiTheme.border.width.thin} solid ${euiTheme.colors.primary};
  `;
  const cardContent = /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "m",
    color: "primary",
    className: panelStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: iconContainerStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "dashboardApp",
    size: "l",
    color: "ghost",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "default",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 13
    }
  }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }, "Dashboard (Temporary)"))));
  if (url) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      external: false,
      href: url,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 7
      }
    }, cardContent);
  }
  return cardContent;
};
function createDashboardRenderer({
  stepsFromCurrentRound,
  stepsFromPrevRounds
}) {
  return props => {
    const {
      toolResultId
    } = props;
    if (!toolResultId) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 109,
          columnNumber: 14
        }
      }, "Dashboard missing ", _tool_result.dashboardElement.attributes.toolResultId, ".");
    }
    const steps = [...stepsFromPrevRounds, ...stepsFromCurrentRound];
    const toolResult = (0, _utils.findToolResult)(steps, toolResultId, _tool_result.ToolResultType.dashboard);
    if (!toolResult) {
      const ToolResultAttribute = /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 9
        }
      }, _tool_result.dashboardElement.attributes.toolResultId, "=", toolResultId);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 125,
          columnNumber: 14
        }
      }, "Unable to find dashboard for ", ToolResultAttribute, ".");
    }
    const {
      title,
      content
    } = toolResult.data;
    const dashboardUrl = content === null || content === void 0 ? void 0 : content.url;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(DashboardCard, {
      title: title || 'Dashboard',
      url: dashboardUrl,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 9
      }
    }));
  };
}