"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MessageEditor = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_input/message_editor/message_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EDITOR_MAX_HEIGHT = 240;
const heightStyles = (0, _react2.css)`
  flex-grow: 1;
  height: 100%;
  max-height: ${EDITOR_MAX_HEIGHT}px;
  overflow-y: auto;
`;
const resetStyles = id => (0, _react2.css)`
  &#${CSS.escape(id)} {
    outline-style: none;
  }
`;
const disabledStyles = (0, _react2.css)`
  &[contenteditable='false'] {
    cursor: not-allowed;
  }
`;
const editorAriaLabel = _i18n.i18n.translate('xpack.onechat.conversationInput.messageEditor.label', {
  defaultMessage: 'Message input'
});
const MessageEditor = ({
  messageEditor,
  onSubmit,
  disabled = false,
  placeholder = '',
  'data-test-subj': dataTestSubj
}) => {
  const {
    ref,
    onChange
  } = messageEditor._internal;
  const editorId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'messageEditor'
  });
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const placeholderStyles = (0, _react2.css)`
    &[data-placeholder]:empty:before {
      content: attr(data-placeholder);
      color: ${euiTheme.colors.textDisabled};
      pointer-events: none;
      display: block;
    }
  `;
  const fontStyles = (0, _react2.css)`
    ${(0, _eui.useEuiFontSize)('m')}
  `;
  const editorStyles = [heightStyles, resetStyles(editorId), disabledStyles, placeholderStyles, fontStyles];
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: ref,
    id: editorId,
    contentEditable: disabled ? 'false' : 'plaintext-only',
    role: "textbox",
    "aria-multiline": "true",
    "aria-label": editorAriaLabel,
    "aria-disabled": disabled,
    tabIndex: 0,
    "data-placeholder": placeholder,
    "data-test-subj": dataTestSubj,
    css: editorStyles,
    onInput: onChange,
    onKeyDown: event => {
      if (!event.shiftKey && event.key === _eui.keys.ENTER) {
        event.preventDefault();
        onSubmit();
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  });
};
exports.MessageEditor = MessageEditor;