"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSelectorListStyles = exports.selectorPopoverPanelStyles = exports.getMaxListHeight = exports.SELECTOR_LIST_HEADER_HEIGHT = exports.SELECTOR_LIST_FOOTER_HEIGHT = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SELECTOR_LIST_HEADER_HEIGHT = exports.SELECTOR_LIST_HEADER_HEIGHT = 57;
const SELECTOR_LIST_FOOTER_HEIGHT = exports.SELECTOR_LIST_FOOTER_HEIGHT = 57;
const SELECTOR_POPOVER_MAX_HEIGHT = 300;
const getMaxListHeight = ({
  withHeader,
  withFooter
}) => {
  let height = SELECTOR_POPOVER_MAX_HEIGHT;
  if (withHeader) {
    height -= SELECTOR_LIST_HEADER_HEIGHT;
  }
  if (withFooter) {
    height -= SELECTOR_LIST_FOOTER_HEIGHT;
  }
  return height;
};
exports.getMaxListHeight = getMaxListHeight;
const SELECTOR_POPOVER_WIDTH = 275;
const selectorPopoverPanelStyles = exports.selectorPopoverPanelStyles = (0, _react.css)`
  inline-size: ${SELECTOR_POPOVER_WIDTH}px;
`;
const useSelectorListStyles = ({
  listId
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const listItemStyles = (0, _react.css)`
    &#${listId} .euiSelectableListItem {
      border-style: none;
      color: unset;
      padding: calc(${euiTheme.size.m} * 0.5) ${euiTheme.size.m};
      :hover {
        background-color: ${euiTheme.colors.backgroundBaseInteractiveSelect};
      }
      & .euiSelectableListItem__content {
        block-size: 100%;
        gap: ${euiTheme.size.s};
        .euiSelectableListItem__icon,
        .euiSelectableListItem__prepend,
        .euiSelectableListItem__append {
          margin: 0;
        }
      }
      & .euiSelectableListItem__text {
        text-decoration: none;
      }
    }
  `;
  const selectedItemStyles = (0, _react.css)`
    &#${listId} .euiSelectableListItem-isFocused {
      :not(:hover) {
        background-color: unset;
      }
    }
  `;
  return [listItemStyles, selectedItemStyles];
};
exports.useSelectorListStyles = useSelectorListStyles;