"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorSelector = void 0;
var _eui = require("@elastic/eui");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _use_ui_privileges = require("../../../../../hooks/use_ui_privileges");
var _use_navigation = require("../../../../../hooks/use_navigation");
var _send_message_context = require("../../../../../context/send_message/send_message_context");
var _use_default_connector = require("../../../../../hooks/chat/use_default_connector");
var _use_kibana = require("../../../../../hooks/use_kibana");
var _input_actions = require("../input_actions.styles");
var _input_popover_button = require("../input_popover_button");
var _option_text = require("../option_text");
var _connector_icon = require("./connector_icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_input/input_actions/connector_selector/connector_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const selectableAriaLabel = _i18n.i18n.translate('xpack.onechat.conversationInput.connectorSelector.selectableAriaLabel', {
  defaultMessage: 'Select a connector'
});
const defaultConnectorLabel = _i18n.i18n.translate('xpack.onechat.conversationInput.connectorSelector.defaultConnectorLabel', {
  defaultMessage: 'Default'
});
const connectorSelectId = 'agentBuilderConnectorSelect';
const connectorListId = `${connectorSelectId}_listbox`;
const CONNECTOR_OPTION_ROW_HEIGHT = 32;
const ConnectorPopoverButton = ({
  isPopoverOpen,
  onClick,
  disabled,
  selectedConnectorName
}) => {
  return /*#__PURE__*/_react.default.createElement(_input_popover_button.InputPopoverButton, {
    open: isPopoverOpen,
    disabled: disabled,
    iconType: () => /*#__PURE__*/_react.default.createElement(_connector_icon.ConnectorIcon, {
      connectorName: selectedConnectorName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 23
      }
    }),
    onClick: onClick,
    "aria-labelledby": connectorSelectId,
    "data-test-subj": "agentBuilderConnectorSelectorButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, selectedConnectorName !== null && selectedConnectorName !== void 0 ? selectedConnectorName : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.conversationInput.connectorSelector.buttonLabel",
    defaultMessage: "LLM",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }));
};
const ConnectorOption = ({
  connectorId,
  connectorName
}) => {
  if (!connectorId) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_option_text.OptionText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 10
    }
  }, connectorName);
};
const DefaultConnectorBadge = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    "data-test-subj": "defaultConnectorBadge",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }, defaultConnectorLabel);
};
const manageConnectorsAriaLabel = _i18n.i18n.translate('xpack.onechat.conversationInput.connectorSelector.manageConnectors.ariaLabel', {
  defaultMessage: 'Manage connectors'
});
const ConnectorListFooter = () => {
  const {
    manageConnectorsUrl
  } = (0, _use_navigation.useNavigation)();
  const {
    showManagement
  } = (0, _use_ui_privileges.useUiPrivileges)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "spaceBetween",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconType: "gear",
    color: "text",
    "aria-label": manageConnectorsAriaLabel,
    href: manageConnectorsUrl,
    disabled: !showManagement,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.conversationInput.agentSelector.manageAgents",
    defaultMessage: "Manage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 13
    }
  })))));
};
const ConnectorSelector = () => {
  const {
    services: {
      http,
      settings
    }
  } = (0, _use_kibana.useKibana)();
  const {
    connectorSelection: {
      selectConnector: onSelectConnector,
      selectedConnector: selectedConnectorId,
      defaultConnectorId
    }
  } = (0, _send_message_context.useSendMessage)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const {
    data: aiConnectors,
    isLoading
  } = (0, _elasticAssistant.useLoadConnectors)({
    http,
    settings,
    inferenceEnabled: true
  });
  const connectors = (0, _react.useMemo)(() => aiConnectors !== null && aiConnectors !== void 0 ? aiConnectors : [], [aiConnectors]);
  const togglePopover = () => setIsPopoverOpen(!isPopoverOpen);
  const closePopover = () => setIsPopoverOpen(false);
  const connectorOptions = (0, _react.useMemo)(() => {
    const options = connectors.map(connector => {
      let checked;
      if (connector.id === selectedConnectorId) {
        checked = 'on';
      }
      const option = {
        key: connector.id,
        label: connector.name,
        checked,
        prepend: /*#__PURE__*/_react.default.createElement(_connector_icon.ConnectorIcon, {
          connectorName: connector.name,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 166,
            columnNumber: 18
          }
        }),
        append: connector.id === defaultConnectorId ? /*#__PURE__*/_react.default.createElement(DefaultConnectorBadge, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 167,
            columnNumber: 55
          }
        }) : undefined
      };
      return option;
    });
    return options;
  }, [connectors, selectedConnectorId, defaultConnectorId]);
  const initialConnectorId = (0, _use_default_connector.useDefaultConnector)({
    connectors,
    defaultConnectorId
  });
  const selectedConnector = connectors.find(c => c.id === selectedConnectorId);
  (0, _react.useEffect)(() => {
    if (!isLoading && initialConnectorId) {
      // No user preference set
      if (!selectedConnectorId) {
        onSelectConnector(initialConnectorId);
      }
      // User preference is set but connector is not available in the list.
      // Scenario: the connector was deleted or admin changed GenAI settings
      else if (selectedConnectorId && !selectedConnector) {
        onSelectConnector(initialConnectorId);
      }
    }
  }, [selectedConnectorId, selectedConnector, isLoading, initialConnectorId, onSelectConnector]);
  const selectorListStyles = (0, _input_actions.useSelectorListStyles)({
    listId: connectorListId
  });
  const listItemsHeight = connectorOptions.length * CONNECTOR_OPTION_ROW_HEIGHT;
  // Calculate height based on item count, capped at max rows
  const listHeight = Math.min(listItemsHeight, (0, _input_actions.getMaxListHeight)({
    withHeader: false
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelProps: {
      css: _input_actions.selectorPopoverPanelStyles
    },
    button: /*#__PURE__*/_react.default.createElement(ConnectorPopoverButton, {
      isPopoverOpen: isPopoverOpen,
      onClick: togglePopover,
      disabled: isLoading || connectors.length === 0,
      selectedConnectorName: selectedConnector === null || selectedConnector === void 0 ? void 0 : selectedConnector.name,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 9
      }
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "upCenter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    id: connectorSelectId,
    "data-test-subj": "agentBuilderConnectorSelector",
    "aria-label": selectableAriaLabel,
    singleSelection: true,
    options: connectorOptions,
    onChange: (_options, _event, changedOption) => {
      const {
        checked,
        key: connectorId
      } = changedOption;
      const isChecked = checked === 'on';
      if (isChecked && connectorId) {
        onSelectConnector(connectorId);
        closePopover();
      }
    },
    renderOption: option => {
      const {
        key: connectorId,
        label: connectorName
      } = option;
      return /*#__PURE__*/_react.default.createElement(ConnectorOption, {
        key: connectorId,
        connectorId: connectorId,
        connectorName: connectorName,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 233,
          columnNumber: 13
        }
      });
    },
    height: listHeight,
    listProps: {
      id: connectorListId,
      css: selectorListStyles,
      rowHeight: CONNECTOR_OPTION_ROW_HEIGHT,
      onFocusBadge: false
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 7
    }
  }, list => /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 11
    }
  }, list, /*#__PURE__*/_react.default.createElement(ConnectorListFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 13
    }
  }))));
};
exports.ConnectorSelector = ConnectorSelector;