"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentSelectDropdown = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _use_ui_privileges = require("../../../../../hooks/use_ui_privileges");
var _use_conversation = require("../../../../../hooks/use_conversation");
var _use_navigation = require("../../../../../hooks/use_navigation");
var _app_paths = require("../../../../../utils/app_paths");
var _robot = require("../../../../common/icons/robot");
var _input_actions = require("../input_actions.styles");
var _use_agent_options = require("./use_agent_options");
var _input_popover_button = require("../input_popover_button");
var _agent_avatar = require("../../../../common/agent_avatar");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_input/input_actions/agent_selector/agent_select_dropdown.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AGENT_OPTION_ROW_HEIGHT = 44;
const selectAgentAriaLabel = _i18n.i18n.translate('xpack.onechat.conversationInput.agentSelector.selectAgent.ariaLabel', {
  defaultMessage: 'Select an agent'
});
const selectAgentFallbackButtonLabel = _i18n.i18n.translate('xpack.onechat.conversationInput.agentSelector.fallbackButtonLabel', {
  defaultMessage: 'Agents'
});
const createAgentAriaLabel = _i18n.i18n.translate('xpack.onechat.conversationInput.agentSelector.createAgent.ariaLabel', {
  defaultMessage: 'Create an agent'
});
const manageAgentsAriaLabel = _i18n.i18n.translate('xpack.onechat.conversationInput.agentSelector.manageAgents.ariaLabel', {
  defaultMessage: 'Manage agents'
});
const agentSelectId = 'agentBuilderAgentSelect';
const agentListId = `${agentSelectId}_listbox`;
const AgentSelectPopoverButton = ({
  isPopoverOpen,
  selectedAgent,
  onClick
}) => {
  var _selectedAgent$name;
  const hasActiveConversation = (0, _use_conversation.useHasActiveConversation)();
  const iconType = selectedAgent ? () => /*#__PURE__*/_react2.default.createElement(_agent_avatar.AgentAvatar, {
    agent: selectedAgent,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 42
    }
  }) : _robot.RobotIcon;
  return /*#__PURE__*/_react2.default.createElement(_input_popover_button.InputPopoverButton, {
    open: isPopoverOpen,
    disabled: hasActiveConversation,
    iconType: iconType,
    onClick: onClick,
    "aria-labelledby": agentSelectId,
    "data-test-subj": "agentBuilderAgentSelectorButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, (_selectedAgent$name = selectedAgent === null || selectedAgent === void 0 ? void 0 : selectedAgent.name) !== null && _selectedAgent$name !== void 0 ? _selectedAgent$name : selectAgentFallbackButtonLabel);
};
const AgentListFooter = () => {
  const {
    manageAgents
  } = (0, _use_ui_privileges.useUiPrivileges)();
  const {
    createOnechatUrl
  } = (0, _use_navigation.useNavigation)();
  const createAgentHref = createOnechatUrl(_app_paths.appPaths.agents.new);
  const manageAgentsHref = createOnechatUrl(_app_paths.appPaths.agents.list);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPopoverFooter, {
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "spaceBetween",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    size: "s",
    iconType: "gear",
    color: "text",
    "aria-label": manageAgentsAriaLabel
  }, manageAgents ? {
    href: manageAgentsHref
  } : {
    disabled: true
  }, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.conversationInput.agentSelector.manageAgents",
    defaultMessage: "Manage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    size: "s",
    iconType: "plus",
    "aria-label": createAgentAriaLabel
  }, manageAgents ? {
    href: createAgentHref
  } : {
    disabled: true
  }, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.conversationInput.agentSelector.createNewAgent",
    defaultMessage: "New",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  })))));
};
const AgentSelectDropdown = ({
  selectedAgent,
  onAgentChange,
  agents = []
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react2.useState)(false);
  const {
    agentOptions,
    renderAgentOption
  } = (0, _use_agent_options.useAgentOptions)({
    agents,
    selectedAgentId: selectedAgent === null || selectedAgent === void 0 ? void 0 : selectedAgent.id
  });
  const selectorListStyles = (0, _react.css)`
    ${(0, _input_actions.useSelectorListStyles)({
    listId: agentListId
  })}
    &#${agentListId} .euiSelectableListItem {
      align-items: flex-start;
    }
  `;
  const listItemsHeight = agentOptions.length * AGENT_OPTION_ROW_HEIGHT;
  // Calculate height based on item count, capped at max rows
  const listHeight = Math.min(listItemsHeight, (0, _input_actions.getMaxListHeight)({
    withFooter: true
  }));
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    panelProps: {
      css: _input_actions.selectorPopoverPanelStyles
    },
    panelPaddingSize: "none",
    button: /*#__PURE__*/_react2.default.createElement(AgentSelectPopoverButton, {
      isPopoverOpen: isPopoverOpen,
      selectedAgent: selectedAgent,
      onClick: () => setIsPopoverOpen(!isPopoverOpen),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 9
      }
    }),
    isOpen: isPopoverOpen,
    anchorPosition: "upCenter",
    closePopover: () => setIsPopoverOpen(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSelectable, {
    id: agentSelectId,
    "aria-label": selectAgentAriaLabel,
    options: agentOptions,
    onChange: (_options, _event, changedOption) => {
      const {
        checked,
        key: agentId
      } = changedOption;
      const isChecked = checked === 'on';
      if (isChecked && agentId) {
        onAgentChange(agentId);
        setIsPopoverOpen(false);
      }
    },
    singleSelection: true,
    renderOption: option => renderAgentOption({
      agent: option.agent
    }),
    height: listHeight,
    listProps: {
      id: agentListId,
      isVirtualized: true,
      rowHeight: AGENT_OPTION_ROW_HEIGHT,
      onFocusBadge: false,
      css: selectorListStyles
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 7
    }
  }, list => /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, list, /*#__PURE__*/_react2.default.createElement(AgentListFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 13
    }
  }))));
};
exports.AgentSelectDropdown = AgentSelectDropdown;