"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttachmentPillsRow = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _attachment_pill = require("./attachment_pill");
var _conversation_context = require("../../../context/conversation/conversation_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_input/attachment_pills_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const labels = {
  attachments: _i18n.i18n.translate('xpack.onechat.attachmentPillsRow.attachments', {
    defaultMessage: 'Attachments'
  })
};
const AttachmentPillsRow = ({
  attachments,
  removable = false,
  justifyContent = 'flexStart'
}) => {
  const {
    removeAttachment
  } = (0, _conversation_context.useConversationContext)();
  if (attachments.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    wrap: true,
    responsive: false,
    justifyContent: justifyContent,
    role: "list",
    "aria-label": labels.attachments,
    "data-test-subj": "onechatAttachmentPillsRow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, attachments.map((attachment, index) => {
    var _attachment$id;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: (_attachment$id = attachment.id) !== null && _attachment$id !== void 0 ? _attachment$id : `${attachment.type}-${index}`,
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_attachment_pill.AttachmentPill, {
      attachment: attachment,
      onRemoveAttachment: removable ? () => removeAttachment === null || removeAttachment === void 0 ? void 0 : removeAttachment(index) : undefined,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 11
      }
    }));
  }));
};
exports.AttachmentPillsRow = AttachmentPillsRow;