"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Conversation = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _use_conversation = require("../../hooks/use_conversation");
var _conversation_input = require("./conversation_input/conversation_input");
var _conversation_rounds = require("./conversation_rounds/conversation_rounds");
var _new_conversation_prompt = require("./new_conversation_prompt");
var _use_conversation_id = require("../../context/conversation/use_conversation_id");
var _use_should_stick_to_bottom = require("../../context/conversation/use_should_stick_to_bottom");
var _send_message_context = require("../../context/send_message/send_message_context");
var _use_conversation_scroll_actions = require("../../hooks/use_conversation_scroll_actions");
var _use_initial_message = require("../../hooks/use_initial_message");
var _conversation = require("./conversation.styles");
var _scroll_button = require("./scroll_button");
var _app_leave_context = require("../../context/app_leave_context");
var _use_navigation_abort = require("../../hooks/use_navigation_abort");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Conversation = () => {
  var _scrollContainerRef$c, _scrollContainerRef$c2;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const conversationId = (0, _use_conversation_id.useConversationId)();
  const hasActiveConversation = (0, _use_conversation.useHasActiveConversation)();
  const {
    isResponseLoading
  } = (0, _send_message_context.useSendMessage)();
  const {
    isFetched
  } = (0, _use_conversation.useConversationStatus)();
  const shouldStickToBottom = (0, _use_should_stick_to_bottom.useShouldStickToBottom)();
  const onAppLeave = (0, _app_leave_context.useAppLeave)();
  (0, _use_initial_message.useSendPredefinedInitialMessage)();
  (0, _use_navigation_abort.useNavigationAbort)({
    onAppLeave,
    isResponseLoading
  });
  const scrollContainerRef = (0, _react2.useRef)(null);
  const {
    showScrollButton,
    scrollToMostRecentRoundBottom,
    scrollToMostRecentRoundTop,
    stickToBottom
  } = (0, _use_conversation_scroll_actions.useConversationScrollActions)({
    isResponseLoading,
    conversationId: conversationId || '',
    scrollContainer: scrollContainerRef.current
  });
  const scrollContainerHeight = (_scrollContainerRef$c = (_scrollContainerRef$c2 = scrollContainerRef.current) === null || _scrollContainerRef$c2 === void 0 ? void 0 : _scrollContainerRef$c2.clientHeight) !== null && _scrollContainerRef$c !== void 0 ? _scrollContainerRef$c : 0;

  // Stick to bottom only when user returns to an existing conversation (conversationId is defined and changes)
  (0, _react2.useEffect)(() => {
    if (isFetched && conversationId && shouldStickToBottom) {
      requestAnimationFrame(() => {
        stickToBottom();
      });
    }
  }, [stickToBottom, isFetched, conversationId, shouldStickToBottom]);
  const containerStyles = (0, _react.css)`
    ${_conversation.fullWidthAndHeightStyles}
  `;

  // Necessary to position the scroll button absolute to the container.
  const scrollWrapperStyles = (0, _react.css)`
    ${_conversation.fullWidthAndHeightStyles}
    position: relative;
    min-height: 0;
  `;

  // TODO: Add custom mask for overflow scroll top and bottom
  const scrollableStyles = (0, _react.css)`
    ${(0, _eui.useEuiScrollBar)()}
    ${(0, _eui.useEuiOverflowScroll)('y')}
  `;
  const inputPaddingStyles = (0, _react.css)`
    padding-bottom: ${euiTheme.size.base};
  `;
  if (!hasActiveConversation) {
    return /*#__PURE__*/_react2.default.createElement(_new_conversation_prompt.NewConversationPrompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    css: containerStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    css: scrollWrapperStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    ref: scrollContainerRef,
    css: scrollableStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: [_conversation.conversationElementWidthStyles, _conversation.conversationElementPaddingStyles],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_conversation_rounds.ConversationRounds, {
    scrollContainerHeight: scrollContainerHeight,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  }))), showScrollButton && /*#__PURE__*/_react2.default.createElement(_scroll_button.ScrollButton, {
    onClick: scrollToMostRecentRoundBottom,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 30
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: [_conversation.conversationElementWidthStyles, _conversation.conversationElementPaddingStyles, inputPaddingStyles],
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_conversation_input.ConversationInput, {
    onSubmit: scrollToMostRecentRoundTop,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  })));
};
exports.Conversation = Conversation;