"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoPrivilegePrompt = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../../../common/doc_links");
var _prompt_layout = require("./prompt_layout");
var _use_asset_base_path = require("../../../hooks/use_asset_base_path");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/access/prompts/no_privilege_prompt.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NoPrivilegePrompt = ({
  variant
}) => {
  const {
    colorMode
  } = (0, _eui.useEuiTheme)();
  const assetBasePath = (0, _use_asset_base_path.useAssetBasePath)();
  const primaryButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    href: _doc_links.docLinks.agentBuilder,
    target: "_blank",
    iconType: "popout",
    iconSide: "right",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.access.prompt.noPrivilege.actions.docsLink",
    defaultMessage: "Learn more",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_prompt_layout.PromptLayout, {
    variant: variant,
    imageSrc: colorMode === 'LIGHT' ? `${assetBasePath}/lock_light.svg` : `${assetBasePath}/lock_dark.svg`,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.access.prompt.noPrivilege.title",
      defaultMessage: "Access denied",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 9
      }
    }),
    subtitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.access.prompt.noPrivilege.description",
      defaultMessage: "You don't have the required privileges to access the Agent Builder. Please contact your administrator.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 9
      }
    }),
    primaryButton: primaryButton,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  });
};
exports.NoPrivilegePrompt = NoPrivilegePrompt;