"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolveResourceWithSamplingStats = void 0;
var _sampling = require("../sampling");
var _resolve_resource = require("./resolve_resource");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Resolve a resource and generate field stats based on sampling
 */
const resolveResourceWithSamplingStats = async ({
  resourceName,
  esClient,
  samplingSize
}) => {
  const [resource, stats] = await Promise.all([(0, _resolve_resource.resolveResource)({
    resourceName,
    esClient
  }), (0, _sampling.getSampleDocs)({
    esClient,
    index: resourceName,
    size: samplingSize
  }).then(({
    samples
  }) => {
    return (0, _sampling.createStatsFromSamples)({
      samples
    });
  })]);
  const combinedFields = (0, _sampling.combineFieldsWithStats)({
    fields: resource.fields,
    stats
  });
  return {
    ...resource,
    fields: combinedFields
  };
};
exports.resolveResourceWithSamplingStats = resolveResourceWithSamplingStats;