"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isMcpTool = isMcpTool;
var _definition = require("../definition");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Configuration for an MCP (Model Context Protocol) Agent Builder tool.
 *
 * An MCP tool maps 1:1 to a tool provided by an MCP server.
 * The MCP server is connected to via an MCP Stack Connector.
 */
// eslint-disable-next-line @typescript-eslint/consistent-type-definitions

function isMcpTool(tool) {
  return tool.type === _definition.ToolType.mcp;
}