"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isToolCallStep = exports.isReasoningStep = exports.createToolCallStep = exports.createReasoningStep = exports.ConversationRoundStepType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Represents a user input that initiated a conversation round.
 */
/**
 * Raw version of RoundInput, as accepted as input by the converse and agent APIs.
 */
/**
 * Represents the final answer from the agent in a conversation round.
 */
let ConversationRoundStepType = exports.ConversationRoundStepType = /*#__PURE__*/function (ConversationRoundStepType) {
  ConversationRoundStepType["toolCall"] = "tool_call";
  ConversationRoundStepType["reasoning"] = "reasoning";
  return ConversationRoundStepType;
}({}); // tool call step
/**
 * Tool call progress which were emitted during the tool execution
 */
/**
 * Represents a tool call with the corresponding result.
 */
const createToolCallStep = toolCallWithResult => {
  return {
    type: ConversationRoundStepType.toolCall,
    ...toolCallWithResult
  };
};
exports.createToolCallStep = createToolCallStep;
const isToolCallStep = step => {
  return step.type === ConversationRoundStepType.toolCall;
};
exports.isToolCallStep = isToolCallStep;
const createReasoningStep = reasoningStepWithResult => {
  return {
    type: ConversationRoundStepType.reasoning,
    ...reasoningStepWithResult
  };
};
exports.createReasoningStep = createReasoningStep;
const isReasoningStep = step => {
  return step.type === ConversationRoundStepType.reasoning;
};

/**
 * Defines all possible types for round steps.
 */

/**
 * Represents a round in a conversation, containing all the information
 * related to this particular round.
 */

/**
 * Main structure representing a conversation with an agent.
 */
exports.isReasoningStep = isReasoningStep;