"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSlosForEntity = getSlosForEntity;
var _kql_query = require("../../es/queries/kql_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getSlosForEntity({
  start,
  end,
  entity,
  esClient,
  sloSummaryIndices,
  size,
  spaceId
}) {
  const slosKuery = Object.entries(entity).map(([field, value]) => {
    return `(slo.groupings.${field}:"${value}")`;
  }).join(' AND ');
  const sloSummaryResponse = await esClient.search('get_slo_summaries_for_entity', {
    index: sloSummaryIndices,
    size,
    track_total_hits: false,
    query: {
      bool: {
        filter: [...(0, _kql_query.kqlQuery)(slosKuery), {
          range: {
            'slo.createdAt': {
              lte: end
            }
          }
        }, {
          range: {
            summaryUpdatedAt: {
              gte: start
            }
          }
        }, {
          term: {
            spaceId
          }
        }]
      }
    }
  });
  return {
    ...sloSummaryResponse,
    hits: {
      ...sloSummaryResponse.hits,
      hits: sloSummaryResponse.hits.hits.map(hit => {
        return {
          ...hit,
          _source: hit._source
        };
      })
    }
  };
}