"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataStreamsForEntity = getDataStreamsForEntity;
var _lodash = require("lodash");
var _exclude_frozen_query = require("../es/queries/exclude_frozen_query");
var _kql_query = require("../es/queries/kql_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getDataStreamsForEntity({
  esClient,
  kuery,
  index
}) {
  var _response$aggregation, _response$aggregation2;
  const response = await esClient.search('get_data_streams_for_entity', {
    track_total_hits: false,
    index,
    size: 0,
    terminate_after: 1,
    timeout: '1ms',
    aggs: {
      indices: {
        terms: {
          field: '_index',
          size: 10000
        }
      }
    },
    query: {
      bool: {
        filter: [...(0, _exclude_frozen_query.excludeFrozenQuery)(), ...(0, _kql_query.kqlQuery)(kuery)]
      }
    }
  });
  const allIndices = (_response$aggregation = (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.indices.buckets.map(bucket => bucket.key)) !== null && _response$aggregation !== void 0 ? _response$aggregation : [];
  if (!allIndices.length) {
    return {
      dataStreams: []
    };
  }
  const resolveIndexResponse = await esClient.client.indices.resolveIndex({
    name: allIndices
  });
  const dataStreams = (0, _lodash.uniq)((0, _lodash.compact)([
  /* Check both data streams and indices.
   * The response body shape differs depending on the request. Example:
   * GET _resolve/index/logs-*-default* will return data in the `data_streams` key.
   * GET _resolve/index/.ds-logs-*-default* will return data in the `indices` key */
  ...resolveIndexResponse.indices.flatMap(idx => {
    const remoteCluster = idx.name.includes(':') ? idx.name.split(':')[0] : null;
    if (remoteCluster) {
      return `${remoteCluster}:${idx.data_stream}`;
    }
    return idx.data_stream;
  }), ...resolveIndexResponse.data_streams.map(ds => ds.name)]));
  return {
    dataStreams
  };
}