"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.termsQuery = termsQuery;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isUndefinedOrNull(value) {
  return value === undefined || value === null;
}
function termsQuery(field, ...values) {
  const filtered = values.filter(value => !isUndefinedOrNull(value));
  if (!filtered.length) {
    return [];
  }
  return [{
    terms: {
      [field]: filtered
    }
  }];
}