"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sampleColor = exports.defaultPalette = exports.createPaletteTransformer = exports.colorTransformer = void 0;
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const euiPalette = (0, _eui.euiPaletteColorBlind)();
const defaultPalette = exports.defaultPalette = {
  color0: euiPalette[1],
  // (blue)
  color1: euiPalette[2],
  // (pink)
  color2: euiPalette[0],
  // (green-ish)
  color3: euiPalette[3],
  // (purple)
  color4: euiPalette[4],
  // (light pink)
  color5: euiPalette[5],
  // (yellow)
  color6: euiPalette[6],
  // (tan)
  color7: euiPalette[7],
  // (orange)
  color8: euiPalette[8],
  // (brown)
  color9: euiPalette[9] // (red)
};
const createPaletteTransformer = palette => color => palette[color];
exports.createPaletteTransformer = createPaletteTransformer;
const colorTransformer = exports.colorTransformer = createPaletteTransformer(defaultPalette);
const sampleColor = (usedColors = []) => {
  const allColors = ['color0', 'color1', 'color2', 'color3', 'color4', 'color5', 'color6', 'color7', 'color8', 'color9'];
  const available = (0, _lodash.difference)(allColors, usedColors);
  return (0, _lodash.first)(available) || allColors[0];
};
exports.sampleColor = sampleColor;