"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesTab = RulesTab;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-utils-plugin/public");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _flyout = require("@kbn/response-ops-rule-form/flyout");
var _common = require("@kbn/observability-shared-plugin/common");
var _common2 = require("../../../common");
var _kibana_react = require("../../utils/kibana_react");
var _use_get_filtered_rule_types = require("../../hooks/use_get_filtered_rule_types");
var _use_rules_table_filters = require("../../hooks/use_rules_table_filters");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/rules/rules_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function RulesTab({
  setRefresh,
  stateRefresh
}) {
  const {
    services
  } = (0, _kibana_react.useKibana)();
  const {
    ruleTypeRegistry,
    actionTypeRegistry,
    triggersActionsUi: {
      getRulesList: RuleList
    }
  } = (0, _kibana_react.useKibana)().services;
  const history = (0, _reactRouterDom.useHistory)();
  const urlStateStorage = (0, _public.createKbnUrlStateStorage)({
    history,
    useHash: false,
    useHashQuery: false
  });
  const filteredRuleTypes = (0, _use_get_filtered_rule_types.useGetFilteredRuleTypes)();
  const {
    stateLastResponse,
    stateParams,
    stateSearch,
    stateStatus,
    stateType,
    ruleConditionsFlyoutOpen,
    ruleIdToEdit,
    handleStatusFilterChange,
    handleLastRunOutcomeFilterChange,
    handleTypeFilterChange,
    handleSearchFilterChange,
    handleRuleParamFilterChange,
    setRuleIdToEdit,
    navigateToEditRuleForm,
    setRuleConditionsFlyoutOpen
  } = (0, _use_rules_table_filters.useRulesTableFilers)({
    urlStateStorage,
    setRefresh
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(RuleList, {
    ruleTypeIds: _common.OBSERVABILITY_RULE_TYPE_IDS_WITH_SUPPORTED_STACK_RULE_TYPES,
    consumers: _common2.observabilityAlertFeatureIds,
    filteredRuleTypes: filteredRuleTypes,
    lastRunOutcomeFilter: stateLastResponse,
    refresh: stateRefresh,
    ruleDetailsRoute: "alerts/rules/:ruleId",
    rulesListKey: "observability_rulesListColumns",
    ruleParamFilter: stateParams,
    showActionFilter: false,
    statusFilter: stateStatus,
    searchFilter: stateSearch,
    typeFilter: stateType,
    navigateToEditRuleForm: navigateToEditRuleForm,
    visibleColumns: ['ruleName', 'ruleExecutionStatusLastDate', 'ruleSnoozeNotify', 'ruleExecutionStatus', 'ruleExecutionState'],
    onLastRunOutcomeFilterChange: handleLastRunOutcomeFilterChange,
    onRuleParamFilterChange: handleRuleParamFilterChange,
    onSearchFilterChange: handleSearchFilterChange,
    onStatusFilterChange: handleStatusFilterChange,
    onTypeFilterChange: handleTypeFilterChange,
    initialSelectedConsumer: _ruleDataUtils.AlertConsumers.LOGS,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }), ruleIdToEdit && ruleConditionsFlyoutOpen ? /*#__PURE__*/_react.default.createElement(_flyout.RuleFormFlyout, {
    plugins: {
      ...services,
      ruleTypeRegistry,
      actionTypeRegistry
    },
    id: ruleIdToEdit,
    onCancel: () => {
      setRuleConditionsFlyoutOpen(false);
      setRuleIdToEdit(null);
    },
    onSubmit: () => {
      setRuleConditionsFlyoutOpen(false);
      setRuleIdToEdit(null);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }) : null);
}