"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSyntheticsTlsRuleData = void 0;
exports.syntheticsTlsAlertParamsToKqlQuery = syntheticsTlsAlertParamsToKqlQuery;
var _esQuery = require("@kbn/es-query");
var _moment = _interopRequireDefault(require("moment"));
var _synthetics_common = require("./synthetics_common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Maps the params for a Synthetics TLS Alert to a KQL query string.
 *
 * @param params from a Synthetics TLS Alert
 * @returns KQL query string
 */
function syntheticsTlsAlertParamsToKqlQuery(params) {
  const {
    certAgeThreshold,
    certExpirationThreshold,
    search,
    kqlQuery,
    ...rest
  } = params;
  const expirationFilters = [];
  const filters = [];
  if (certExpirationThreshold) {
    expirationFilters.push(_esQuery.nodeBuilder.range('tls.server.x509.not_after', 'lt', (0, _moment.default)().add(certExpirationThreshold, 'days').toISOString()));
  }
  if (certAgeThreshold) {
    expirationFilters.push(_esQuery.nodeBuilder.range('tls.server.x509.not_before', 'lt', (0, _moment.default)().subtract(certAgeThreshold, 'days').toISOString()));
  }
  if (expirationFilters.length) {
    filters.push(_esQuery.nodeBuilder.or(expirationFilters));
  }
  filters.push(...(0, _synthetics_common.mapExtraSyntheticsFilters)(rest, kqlQuery));
  if (filters.length === 0) return '';
  return (0, _esQuery.toKqlExpression)(_esQuery.nodeBuilder.and(filters));
}
const getSyntheticsTlsRuleData = ({
  rule
}) => {
  const params = rule.params;
  const query = syntheticsTlsAlertParamsToKqlQuery(params);
  return {
    discoverAppLocatorParams: {
      query: {
        language: 'kuery',
        query
      },
      dataViewSpec: _synthetics_common.SYNTHETICS_TEMP_DATA_VIEW
    }
  };
};
exports.getSyntheticsTlsRuleData = getSyntheticsTlsRuleData;