"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCustomThresholdRuleData = void 0;
var _esQuery = require("@kbn/es-query");
var _get_view_in_app_url = require("../../../../../../common/custom_threshold_rule/get_view_in_app_url");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCustomThresholdRuleData = ({
  rule
}) => {
  const ruleParams = rule.params;
  const {
    index
  } = ruleParams.searchConfiguration;
  let dataViewId;
  if (typeof index === 'string') {
    dataViewId = index;
  } else if (index) {
    dataViewId = index.title;
  }
  const filters = ruleParams.criteria.flatMap(({
    metrics
  }) => metrics.map(metric => {
    return metric.filter && dataViewId ? (0, _esQuery.buildCustomFilter)(dataViewId, (0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(metric.filter)), true, false, null, _esQuery.FilterStateStore.APP_STATE) : undefined;
  })).filter(f => f !== undefined);
  return {
    discoverAppLocatorParams: {
      ...(0, _get_view_in_app_url.getViewInAppLocatorParams)({
        dataViewId,
        searchConfiguration: {
          index: ruleParams.searchConfiguration.index,
          query: ruleParams.searchConfiguration.query,
          filter: ruleParams.searchConfiguration.filter
        }
      }),
      filters
    }
  };
};
exports.getCustomThresholdRuleData = getCustomThresholdRuleData;