"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertsIndexPatternRuleData = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAlertsIndexPatternRuleData = ({
  alert,
  rule
}) => {
  const indexPattern = _ruleDataUtils.ALERT_INDEX_PATTERN in alert.fields ? alert.fields[_ruleDataUtils.ALERT_INDEX_PATTERN] : undefined;
  if (typeof indexPattern !== 'string') {
    return {};
  }
  const discoverAppLocatorParams = {
    dataViewSpec: {
      title: indexPattern,
      timeFieldName: '@timestamp'
    }
  };
  const filterQueryText = rule.params.filterQueryText;
  if (typeof filterQueryText === 'string' && filterQueryText) {
    discoverAppLocatorParams.query = {
      query: filterQueryText,
      language: 'kuery'
    };
  }
  return {
    discoverAppLocatorParams
  };
};
exports.getAlertsIndexPatternRuleData = getAlertsIndexPatternRuleData;