"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.overviewColumns = exports.ColumnIDs = void 0;
var _eui = require("@elastic/eui");
var _alert_lifecycle_status_badge = require("@kbn/alerts-ui-shared/src/alert_lifecycle_status_badge");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _casesComponents = require("@kbn/cases-components");
var _public = require("@kbn/observability-shared-plugin/public");
var _alertingComparators = require("@kbn/alerting-comparators");
var _convert_legacy_outside_comparator = require("../../../common/utils/convert_legacy_outside_comparator");
var _format_cases = require("./helpers/format_cases");
var _groups = require("../alert_sources/groups");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/alert_overview/overview_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Formats a comparator string for display.
 * Converts NOT_BETWEEN and OUTSIDE_RANGE to 'NOT BETWEEN', otherwise returns uppercase.
 */
const formatComparator = comparator => {
  if (comparator === _alertingComparators.COMPARATORS.NOT_BETWEEN || comparator === _convert_legacy_outside_comparator.LEGACY_COMPARATORS.OUTSIDE_RANGE) {
    // No need for i18n as we are using the enum value, we only need a space.
    return 'NOT BETWEEN';
  }
  return comparator.toUpperCase();
};

/**
 * Renders threshold rows for a list of criteria.
 * Combines alert threshold and warning threshold into one line when warning threshold exists.
 */
const renderThresholdRows = ruleCriteria => {
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, ruleCriteria.map((criteria, index) => {
    const {
      threshold,
      comparator,
      warningThreshold,
      warningComparator
    } = criteria;
    const formattedComparator = formatComparator(comparator);
    // threshold is typed as string[] but is actually a string at runtime
    const thresholdStr = Array.isArray(threshold) ? threshold.join(' AND ') : threshold;
    let thresholdText = _i18n.i18n.translate('xpack.observability.alertFlyout.overviewTab.thresholdAlert', {
      defaultMessage: '{comparator} {threshold}',
      values: {
        comparator: formattedComparator,
        threshold: thresholdStr
      }
    });
    if (warningThreshold && warningComparator) {
      const formattedWarningComparator = formatComparator(warningComparator);
      thresholdText = _i18n.i18n.translate('xpack.observability.alertFlyout.overviewTab.thresholdWithWarning', {
        defaultMessage: 'Alert when {comparator} {threshold}, Warning when {warningComparator} {warningThreshold}',
        values: {
          comparator: formattedComparator,
          threshold: thresholdStr,
          warningComparator: formattedWarningComparator,
          warningThreshold
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      key: `${thresholdStr}-${index}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 13
      }
    }, thresholdText));
  }));
};
const ColumnIDs = exports.ColumnIDs = {
  STATUS: 'status',
  SOURCE: 'source',
  TRIGGERED: 'triggered',
  DURATION: 'duration',
  OBSERVED_VALUE: 'observed_value',
  THRESHOLD: 'threshold',
  RULE_NAME: 'rule_name',
  RULE_TYPE: 'rule_type',
  CASES: 'cases',
  WORKFLOW_TAGS: 'workflow_tags'
};
const overviewColumns = exports.overviewColumns = [{
  field: 'key',
  name: '',
  width: '30%'
}, {
  field: 'value',
  name: '',
  render: (value, {
    id,
    meta
  }) => {
    if (!value && value !== 0 && !meta) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, '-');
    const ruleCriteria = meta === null || meta === void 0 ? void 0 : meta.ruleCriteria;
    switch (id) {
      case ColumnIDs.STATUS:
        const alertStatus = value;
        const flapping = meta === null || meta === void 0 ? void 0 : meta.flapping;
        return /*#__PURE__*/_react.default.createElement(_alert_lifecycle_status_badge.AlertLifecycleStatusBadge, {
          alertStatus: alertStatus,
          flapping: flapping,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 125,
            columnNumber: 13
          }
        });
      case ColumnIDs.SOURCE:
        const groups = meta === null || meta === void 0 ? void 0 : meta.groups;
        if (!groups.length) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, '-');
        const alertEnd = meta === null || meta === void 0 ? void 0 : meta.alertEnd;
        const timeRange = meta === null || meta === void 0 ? void 0 : meta.timeRange;
        return /*#__PURE__*/_react.default.createElement("div", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 137,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_groups.Groups, {
          groups: groups,
          timeRange: alertEnd ? timeRange : {
            ...timeRange,
            to: 'now'
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 138,
            columnNumber: 15
          }
        }));
      case ColumnIDs.TRIGGERED:
        const triggeredDate = value;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 146,
            columnNumber: 18
          }
        }, (0, _moment.default)(triggeredDate).format(meta === null || meta === void 0 ? void 0 : meta.dateFormat));
      case ColumnIDs.DURATION:
        const duration = value;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 150,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement("h4", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 152,
            columnNumber: 15
          }
        }, _moment.default.duration(duration / 1000).humanize()));
      case ColumnIDs.RULE_NAME:
        const ruleName = value;
        const ruleLink = meta === null || meta === void 0 ? void 0 : meta.ruleLink;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "alertFlyoutOverview",
          href: ruleLink ? ruleLink : '#',
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 159,
            columnNumber: 13
          }
        }, ruleName);
      case ColumnIDs.OBSERVED_VALUE:
        if (!ruleCriteria) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, '-');
        return /*#__PURE__*/_react.default.createElement("div", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 166,
            columnNumber: 13
          }
        }, ruleCriteria.map((criteria, criteriaIndex) => {
          const observedValue = criteria.observedValue;
          const pctAboveThreshold = criteria.pctAboveThreshold;
          return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "s",
            key: `${observedValue}-${criteriaIndex}`,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 171,
              columnNumber: 19
            }
          }, /*#__PURE__*/_react.default.createElement("h4", {
            style: {
              display: 'inline'
            },
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 172,
              columnNumber: 21
            }
          }, observedValue), /*#__PURE__*/_react.default.createElement("span", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 173,
              columnNumber: 21
            }
          }, pctAboveThreshold));
        }), ruleCriteria.length > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
          announceOnMount: true,
          size: "s",
          title: _i18n.i18n.translate('xpack.observability.columns.euiCallOut.multipleConditionsLabel', {
            defaultMessage: 'Multiple conditions'
          }),
          iconType: "alert",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 178,
            columnNumber: 17
          }
        }));
      case ColumnIDs.THRESHOLD:
        if (!ruleCriteria) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, '-');
        return renderThresholdRows(ruleCriteria);
      case ColumnIDs.RULE_TYPE:
        const ruleType = value;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 197,
            columnNumber: 18
          }
        }, ruleType);
      case ColumnIDs.CASES:
        const cases = meta === null || meta === void 0 ? void 0 : meta.cases;
        const isLoading = meta === null || meta === void 0 ? void 0 : meta.isLoading;
        if (isLoading) return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
          size: "m",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 202,
            columnNumber: 33
          }
        });
        if (!cases || !cases.length) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, '-');
        const navigateToCaseView = meta === null || meta === void 0 ? void 0 : meta.navigateToCaseView;
        return cases.map((caseInfo, index) => {
          return [index > 0 && index < cases.length && ', ', /*#__PURE__*/_react.default.createElement(_casesComponents.Tooltip, {
            loading: false,
            content: (0, _format_cases.formatCase)(caseInfo),
            key: caseInfo.id,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 208,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            key: caseInfo.id,
            onClick: () => navigateToCaseView({
              caseId: caseInfo.id
            }),
            "data-test-subj": "o11yAlertFlyoutOverviewTabCasesLink",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 209,
              columnNumber: 17
            }
          }, caseInfo.title))];
        });
      case ColumnIDs.WORKFLOW_TAGS:
        const workflowTags = value;
        if (!workflowTags || !workflowTags.length) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, '-');
        return /*#__PURE__*/_react.default.createElement(_public.TagsList, {
          tags: workflowTags,
          ignoreEmpty: true,
          color: "default",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 222,
            columnNumber: 18
          }
        });
      default:
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, '-');
    }
  }
}];