"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SupportedIntegrationsList = SupportedIntegrationsList;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _apache = _interopRequireDefault(require("../../../assets/apache.svg"));
var _docker = _interopRequireDefault(require("../../../assets/docker.svg"));
var _nginx = _interopRequireDefault(require("../../../assets/nginx.svg"));
var _mysql = _interopRequireDefault(require("../../../assets/mysql.svg"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_onboarding/public/application/quickstart_flows/auto_detect/supported_integrations_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SUPPORTED_INTEGRATIONS_LIST = ['Apache', 'Docker', 'Nginx', 'System', 'MySQL', 'PostgreSQL', 'Redis', 'Haproxy', 'Kafka', 'RabbitMQ', 'Prometheus', 'Apache Tomcat', 'MongoDB'];
const FEATURED_INTEGRATIONS_LIST = [{
  title: 'Apache',
  icon: _apache.default
}, {
  title: 'Docker',
  icon: _docker.default
}, {
  title: 'Nginx',
  icon: _nginx.default
}, {
  title: 'MySQL',
  icon: _mysql.default
}, {
  title: 'System',
  icon: 'desktop'
}];
function SupportedIntegrationsList() {
  const {
    euiTheme: {
      colors
    }
  } = (0, _eui.useEuiTheme)();
  const customLogFilesTitle = _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.supportedIntegrationsList.customIntegrationTitle', {
    defaultMessage: 'Custom .log files'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    css: {
      flexWrap: 'wrap'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, FEATURED_INTEGRATIONS_LIST.map(({
    title,
    icon
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    iconType: icon,
    color: "hollow",
    key: title,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    iconType: "documents",
    color: "hollow",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, customLogFilesTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("ul", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 13
      }
    }, SUPPORTED_INTEGRATIONS_LIST.map(integration => /*#__PURE__*/_react.default.createElement("li", {
      key: integration,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 17
      }
    }, integration)), /*#__PURE__*/_react.default.createElement("li", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 15
      }
    }, customLogFilesTitle))),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    tabIndex: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: colors.link,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }, `+${SUPPORTED_INTEGRATIONS_LIST.length - FEATURED_INTEGRATIONS_LIST.length}`))));
}