"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatFunctionClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _ajv = _interopRequireDefault(require("ajv"));
var _lodash = require("lodash");
var _errors = require("@kbn/inference-plugin/common/chat_complete/errors");
var _filter_function_definitions = require("../../../common/utils/filter_function_definitions");
var _get_data_on_screen = require("../../functions/get_data_on_screen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ajv = new _ajv.default({
  strict: false
});
class ChatFunctionClient {
  constructor(screenContexts) {
    (0, _defineProperty2.default)(this, "instructions", []);
    (0, _defineProperty2.default)(this, "functionRegistry", new Map());
    (0, _defineProperty2.default)(this, "validators", new Map());
    (0, _defineProperty2.default)(this, "actions", void 0);
    (0, _defineProperty2.default)(this, "registerFunction", (definition, respond) => {
      if (definition.parameters) {
        this.validators.set(definition.name, ajv.compile(definition.parameters));
      }
      this.functionRegistry.set(definition.name, {
        handler: {
          definition,
          respond
        }
      });
    });
    (0, _defineProperty2.default)(this, "registerInstruction", instruction => {
      this.instructions.push(instruction);
    });
    this.screenContexts = screenContexts;
    this.actions = (0, _lodash.compact)(screenContexts.flatMap(context => context.actions));
    (0, _get_data_on_screen.registerGetDataOnScreenFunction)(this, screenContexts);
    this.actions.forEach(action => {
      if (action.parameters) {
        this.validators.set(action.name, ajv.compile(action.parameters));
      }
    });
  }
  validate(name, parameters) {
    const validator = this.validators.get(name);
    if (!validator) {
      return;
    }
    const result = validator(parameters);
    if (!result) {
      var _validator$errors;
      throw (0, _errors.createToolValidationError)(`Tool call arguments for ${name} were invalid`, {
        name,
        errorsText: (_validator$errors = validator.errors) === null || _validator$errors === void 0 ? void 0 : _validator$errors.map(error => error.message).join(', '),
        arguments: JSON.stringify(parameters),
        toolCalls: []
      });
    }
  }
  getInstructions() {
    return this.instructions;
  }
  hasAction(name) {
    return !!this.actions.find(action => action.name === name);
  }
  getFunctions({
    filter
  } = {}) {
    const allFunctions = Array.from(this.functionRegistry.values()).map(({
      handler
    }) => handler);
    const functionsByName = (0, _lodash.keyBy)(allFunctions, definition => definition.definition.name);
    const matchingDefinitions = (0, _filter_function_definitions.filterFunctionDefinitions)({
      filter,
      definitions: allFunctions.map(fn => fn.definition)
    });
    return matchingDefinitions.map(definition => functionsByName[definition.name]);
  }
  getActions() {
    return this.actions;
  }
  hasFunction(name) {
    return this.functionRegistry.has(name);
  }
  async executeFunction({
    chat,
    name,
    args,
    messages,
    signal,
    logger,
    connectorId,
    simulateFunctionCalling
  }) {
    const fn = this.functionRegistry.get(name);
    if (!fn) {
      throw new Error(`Function ${name} not found`);
    }
    const parsedArguments = args ? JSON.parse(args) : {};
    this.validate(name, parsedArguments);
    logger.debug(() => `Executing function ${name} with arguments: ${JSON.stringify(parsedArguments)}`);
    try {
      return await fn.handler.respond({
        arguments: parsedArguments,
        messages,
        screenContexts: this.screenContexts,
        chat,
        connectorId,
        simulateFunctionCalling
      }, signal);
    } catch (e) {
      logger.error(`Error executing function "${name}": ${e.message}`);
      logger.error(e);
      throw e;
    }
  }
}
exports.ChatFunctionClient = ChatFunctionClient;