"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.connectorRoutes = void 0;
var _inferenceCommon = require("@kbn/inference-common");
var _inference_endpoint_exists = require("@kbn/inference-endpoint-plugin/server/lib/inference_endpoint_exists");
var _create_observability_ai_assistant_server_route = require("../create_observability_ai_assistant_server_route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const listConnectorsRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'GET /internal/observability_ai_assistant/connectors',
  security: {
    authz: {
      requiredPrivileges: ['ai_assistant']
    }
  },
  handler: async resources => {
    const {
      request,
      plugins,
      context
    } = resources;
    const esClient = (await context.core).elasticsearch.client.asInternalUser;
    const actionsClient = await (await plugins.actions.start()).getActionsClientWithRequest(request);
    const [availableTypes, connectors] = await Promise.all([actionsClient.listTypes({
      includeSystemActionTypes: false
    }).then(types => types.filter(type => type.enabled && type.enabledInLicense && type.enabledInConfig).map(type => type.id)), actionsClient.getAll()]);
    const filteredConnectors = [];
    for (const connector of connectors) {
      const hasAllowedType = availableTypes.includes(connector.actionTypeId);
      const isSupported = (0, _inferenceCommon.isSupportedConnector)(connector);
      if (!hasAllowedType || !isSupported) continue;
      if (connector.actionTypeId === _inferenceCommon.InferenceConnectorType.Inference) {
        var _connector$config;
        const endpointExists = await (0, _inference_endpoint_exists.inferenceEndpointExists)(esClient, (_connector$config = connector.config) === null || _connector$config === void 0 ? void 0 : _connector$config.inferenceId);
        if (!endpointExists) continue;
      }
      filteredConnectors.push(connector);
    }
    return filteredConnectors;
  }
});
const connectorRoutes = exports.connectorRoutes = {
  ...listConnectorsRoute
};