"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsAgentBuilderEnabled = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _aiAssistantCommon = require("@kbn/ai-assistant-common");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIsAgentBuilderEnabled = () => {
  var _capabilities$agentBu;
  const [chatExperience] = (0, _public.useUiSetting$)(_managementSettingsIds.AI_CHAT_EXPERIENCE_TYPE);
  const {
    application: {
      capabilities
    }
  } = (0, _use_kibana.useKibana)().services;
  const hasAgentBuilderAccess = (capabilities === null || capabilities === void 0 ? void 0 : (_capabilities$agentBu = capabilities.agentBuilder) === null || _capabilities$agentBu === void 0 ? void 0 : _capabilities$agentBu.show) === true;
  const isAgentChatExperienceEnabled = chatExperience === _aiAssistantCommon.AIChatExperience.Agent;
  return {
    isAgentBuilderEnabled: hasAgentBuilderAccess && isAgentChatExperienceEnabled,
    hasAgentBuilderAccess,
    isAgentChatExperienceEnabled
  };
};
exports.useIsAgentBuilderEnabled = useIsAgentBuilderEnabled;