"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticLlmTourCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _tour_callout = require("./tour_callout");
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/observability_ai_assistant/public/components/tour_callout/elastic_llm_tour_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ElasticLlmTourCallout = ({
  children,
  isOpen = true,
  zIndex,
  dismissTour
}) => {
  const {
    docLinks
  } = (0, _use_kibana.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_tour_callout.TourCallout, {
    title: _i18n.i18n.translate('xpack.observabilityAiAssistant.tour.elasticLlmTitle', {
      defaultMessage: 'Elastic Managed LLM connector now available'
    }),
    subtitle: _i18n.i18n.translate('xpack.observabilityAiAssistant.tour.subtitle', {
      defaultMessage: 'New AI feature!'
    }),
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observabilityAiAssistant.tour.elasticLlmContent",
      defaultMessage: "This new default LLM connector is optimized for Elastic AI features (<costLink>additional costs incur</costLink>). You can continue using existing LLM connectors if you prefer. <learnMoreLink>Learn more</learnMoreLink>",
      values: {
        costLink: (...chunks) => {
          var _docLinks$links, _docLinks$links$obser;
          return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: docLinks === null || docLinks === void 0 ? void 0 : (_docLinks$links = docLinks.links) === null || _docLinks$links === void 0 ? void 0 : (_docLinks$links$obser = _docLinks$links.observability) === null || _docLinks$links$obser === void 0 ? void 0 : _docLinks$links$obser.elasticManagedLlmUsageCost,
            target: "_blank",
            rel: "noopener noreferrer",
            external: true,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 43,
              columnNumber: 15
            }
          }, chunks);
        },
        learnMoreLink: (...chunks) => {
          var _docLinks$links2, _docLinks$links2$obse;
          return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: docLinks === null || docLinks === void 0 ? void 0 : (_docLinks$links2 = docLinks.links) === null || _docLinks$links2 === void 0 ? void 0 : (_docLinks$links2$obse = _docLinks$links2.observability) === null || _docLinks$links2$obse === void 0 ? void 0 : _docLinks$links2$obse.elasticManagedLlm,
            target: "_blank",
            rel: "noopener noreferrer",
            external: true,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 53,
              columnNumber: 15
            }
          }, chunks);
        }
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 9
      }
    }),
    step: 1,
    stepsTotal: 1,
    anchorPosition: "downLeft",
    isOpen: isOpen,
    hasArrow: true,
    footerButtonLabel: _i18n.i18n.translate('xpack.observabilityAiAssistant.tour.footerButtonLabel', {
      defaultMessage: 'Ok'
    }),
    zIndex: zIndex,
    dismissTour: dismissTour,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, children);
};
exports.ElasticLlmTourCallout = ElasticLlmTourCallout;