"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AIAgentTourCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _aiAgentConfirmationModal = require("@kbn/ai-agent-confirmation-modal");
var _tour_callout = require("./tour_callout");
var _use_kibana = require("../../hooks/use_kibana");
var _use_ai_agent_tour_dismissed = require("../../hooks/use_ai_agent_tour_dismissed");
var _use_agent_builder_opt_in = require("../../hooks/use_agent_builder_opt_in");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/observability_ai_assistant/public/components/tour_callout/ai_agent_tour_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AIAgentTourCallout = ({
  children,
  zIndex,
  isConversationApp = false
}) => {
  const {
    application,
    docLinks
  } = (0, _use_kibana.useKibana)().services;
  const {
    showAgentBuilderOptInCta,
    isAgentBuilderConfirmationModalOpen,
    openAgentBuilderConfirmationModal,
    closeAgentBuilderConfirmationModal,
    confirmAgentBuilderOptIn
  } = (0, _use_agent_builder_opt_in.useAgentBuilderOptIn)({
    navigateFromConversationApp: isConversationApp
  });
  const [dismissed, setDismissed] = (0, _use_ai_agent_tour_dismissed.useAIAgentTourDismissed)();
  const handleSkip = (0, _react.useCallback)(() => {
    setDismissed(true);
  }, [setDismissed]);
  const handleContinue = (0, _react.useCallback)(() => {
    openAgentBuilderConfirmationModal();
  }, [openAgentBuilderConfirmationModal]);
  const handleCancelInConfirmationModal = (0, _react.useCallback)(() => {
    closeAgentBuilderConfirmationModal();
  }, [closeAgentBuilderConfirmationModal]);
  if (dismissed || !showAgentBuilderOptInCta) {
    return children;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_tour_callout.TourCallout, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.observabilityAiAssistant.agentTour.title', {
      defaultMessage: 'Try the new AI Agent'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: _i18n.i18n.translate('xpack.observabilityAiAssistant.agentTour.betaBadge', {
        defaultMessage: 'BETA'
      }),
      size: "s",
      color: "hollow",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 15
      }
    }))),
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observabilityAiAssistant.agentTour.body",
      defaultMessage: "Based on the new Agent Builder platform, start testing our agent-based chat experience. You can switch back to the default experience at any time in the {genAiSettingsLink}. Learn more in our {documentationLink}.",
      values: {
        genAiSettingsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: application === null || application === void 0 ? void 0 : application.getUrlForApp('management', {
            path: '/ai/genAiSettings'
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 92,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.observabilityAiAssistant.agentTour.genAiSettingsLabel",
          defaultMessage: "GenAI Settings",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 95,
            columnNumber: 19
          }
        })),
        documentationLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.agentBuilder.agentBuilder,
          target: "_blank",
          rel: "noopener noreferrer",
          external: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 102,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.observabilityAiAssistant.agentTour.documentationLabel",
          defaultMessage: "documentation",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 108,
            columnNumber: 19
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 11
      }
    }),
    step: 1,
    stepsTotal: 1,
    anchorPosition: "downLeft",
    hasArrow: true,
    zIndex: zIndex,
    dismissTour: handleSkip,
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      color: "text",
      onClick: handleSkip,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.observabilityAiAssistant.agentTour.skipButton', {
      defaultMessage: 'Skip'
    }))), showAgentBuilderOptInCta ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      onClick: handleContinue,
      color: "success",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.observabilityAiAssistant.agentTour.continueButton', {
      defaultMessage: 'Continue'
    }))) : null),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, children), isAgentBuilderConfirmationModalOpen && /*#__PURE__*/_react.default.createElement(_aiAgentConfirmationModal.AIAgentConfirmationModal, {
    onConfirm: async () => {
      setDismissed(true);
      await confirmAgentBuilderOptIn();
    },
    onCancel: handleCancelInConfirmationModal,
    docLinks: docLinks.links,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 9
    }
  }));
};
exports.AIAgentTourCallout = AIAgentTourCallout;