"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withTokenBudget = withTokenBudget;
var _gptTokenizer = require("gpt-tokenizer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function withTokenBudget(items, budget, options) {
  var _options$contentAcces, _options$maximizeBudg;
  const contentAccessor = (_options$contentAcces = options === null || options === void 0 ? void 0 : options.contentAccessor) !== null && _options$contentAcces !== void 0 ? _options$contentAcces : asStringAccessor;
  const maximizeBudget = (_options$maximizeBudg = options === null || options === void 0 ? void 0 : options.maximizeBudget) !== null && _options$maximizeBudg !== void 0 ? _options$maximizeBudg : false;
  const itemsWithinBudget = [];
  let usedBudget = 0;
  for (const item of items) {
    const content = contentAccessor(item);
    const tokenCount = (0, _gptTokenizer.encode)(content).length;
    const fitsInBudget = usedBudget + tokenCount <= budget;
    if (fitsInBudget) {
      itemsWithinBudget.push(item);
      usedBudget += tokenCount;
    } else if (maximizeBudget) {
      continue;
    } else {
      break;
    }
  }
  return itemsWithinBudget;
}
function asStringAccessor(item) {
  if (typeof item === 'string') {
    return item;
  }
  return JSON.stringify(item);
}