"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountManagementSection = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _reactQuery = require("@kbn/react-query");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _config = require("./routes/config");
var _redirect_to_home_if_unauthorized = require("./routes/components/redirect_to_home_if_unauthorized");
var _app_context = require("./context/app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/observability_ai_assistant_management/public/app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const mountManagementSection = async ({
  core,
  mountParams,
  config
}) => {
  const [coreStart, startDeps] = await core.getStartServices();
  if (!startDeps.observabilityAIAssistant) return () => {};
  const {
    element,
    history,
    setBreadcrumbs
  } = mountParams;
  const {
    theme$
  } = core.theme;
  coreStart.chrome.docTitle.change(_i18n.i18n.translate('xpack.observabilityAiAssistantManagement.app.titleBar', {
    defaultMessage: 'AI Assistant'
  }));
  const queryClient = new _reactQuery.QueryClient();
  _reactDom.default.render((0, _public.wrapWithTheme)(/*#__PURE__*/_react.default.createElement(_redirect_to_home_if_unauthorized.RedirectToHomeIfUnauthorized, {
    coreStart: coreStart,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...coreStart,
      ...startDeps
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_app_context.AppContextProvider, {
    value: {
      setBreadcrumbs,
      config
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.RouterProvider, {
    history: history,
    router: _config.aIAssistantManagementObservabilityRouter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.RouteRenderer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 19
    }
  }))))))), theme$), element);
  return () => {
    coreStart.chrome.docTitle.reset();
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.mountManagementSection = mountManagementSection;