"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OBSERVABILITY_AGENT_TOOL_IDS = void 0;
exports.registerTools = registerTools;
var _onechatCommon = require("@kbn/onechat-common");
var _tool = require("./run_log_rate_analysis/tool");
var _tool2 = require("./get_anomaly_detection_jobs/tool");
var _tool3 = require("./get_alerts/tool");
var _tool4 = require("./get_log_categories/tool");
var _tool5 = require("./get_correlated_logs/tool");
var _tool6 = require("./get_hosts/tool");
var _tool7 = require("./get_services/tool");
var _tool8 = require("./get_downstream_dependencies/tool");
var _tool9 = require("./get_trace_metrics/tool");
var _tool10 = require("./get_log_change_points/tool");
var _tool11 = require("./get_metric_change_points/tool");
var _get_index_info = require("./get_index_info");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PLATFORM_TOOL_IDS = [_onechatCommon.platformCoreTools.listIndices, _onechatCommon.platformCoreTools.getIndexMapping, _onechatCommon.platformCoreTools.getDocumentById, _onechatCommon.platformCoreTools.productDocumentation];
const OBSERVABILITY_TOOL_IDS = [_tool.OBSERVABILITY_RUN_LOG_RATE_ANALYSIS_TOOL_ID, _tool2.OBSERVABILITY_GET_ANOMALY_DETECTION_JOBS_TOOL_ID, _tool3.OBSERVABILITY_GET_ALERTS_TOOL_ID, _tool4.OBSERVABILITY_GET_LOG_CATEGORIES_TOOL_ID, _tool5.OBSERVABILITY_GET_CORRELATED_LOGS_TOOL_ID, _tool7.OBSERVABILITY_GET_SERVICES_TOOL_ID, _tool8.OBSERVABILITY_GET_DOWNSTREAM_DEPENDENCIES_TOOL_ID, _tool6.OBSERVABILITY_GET_HOSTS_TOOL_ID, _tool9.OBSERVABILITY_GET_TRACE_METRICS_TOOL_ID, _tool10.OBSERVABILITY_GET_LOG_CHANGE_POINTS_TOOL_ID, _tool11.OBSERVABILITY_GET_METRIC_CHANGE_POINTS_TOOL_ID, _get_index_info.OBSERVABILITY_GET_INDEX_INFO_TOOL_ID];
const OBSERVABILITY_AGENT_TOOL_IDS = exports.OBSERVABILITY_AGENT_TOOL_IDS = [...PLATFORM_TOOL_IDS, ...OBSERVABILITY_TOOL_IDS];
async function registerTools({
  core,
  plugins,
  dataRegistry,
  logger
}) {
  const observabilityTools = [(0, _tool.createRunLogRateAnalysisTool)({
    core,
    logger
  }), (0, _tool2.createGetAnomalyDetectionJobsTool)({
    core,
    plugins,
    logger
  }), (0, _tool3.createGetAlertsTool)({
    core,
    logger
  }), (0, _tool4.createGetLogCategoriesTool)({
    core,
    logger
  }), (0, _tool7.createGetServicesTool)({
    core,
    plugins,
    dataRegistry,
    logger
  }), (0, _tool8.createDownstreamDependenciesTool)({
    core,
    dataRegistry,
    logger
  }), (0, _tool5.createGetCorrelatedLogsTool)({
    core,
    logger
  }), (0, _tool6.createGetHostsTool)({
    core,
    logger,
    dataRegistry
  }), (0, _tool9.createGetTraceMetricsTool)({
    core,
    dataRegistry,
    logger
  }), (0, _tool10.createGetLogChangePointsTool)({
    core,
    plugins,
    logger
  }), (0, _tool11.createGetMetricChangePointsTool)({
    core,
    plugins,
    logger
  }), (0, _get_index_info.createGetIndexInfoTool)({
    core,
    plugins,
    logger
  })];
  for (const tool of observabilityTools) {
    plugins.onechat.tools.register(tool);
  }
}