"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndexPatternsHandler = getIndexPatternsHandler;
var _get_observability_data_sources = require("../../utils/get_observability_data_sources");
var _get_data_streams_handler = require("./get_data_streams_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns observability index patterns and discovered data streams.
 * The data streams help identify what specific datasets exist in the cluster,
 * enabling more targeted field discovery (e.g., query metrics-system.memory-* for memory fields).
 */
async function getIndexPatternsHandler({
  core,
  plugins,
  esClient,
  logger
}) {
  const dataSources = await (0, _get_observability_data_sources.getObservabilityDataSources)({
    core,
    plugins,
    logger
  });
  const dataStreams = await (0, _get_data_streams_handler.getDataStreamsHandler)({
    esClient,
    dataSources,
    logger
  });
  return {
    indexPatterns: {
      apm: {
        transaction: dataSources.apmIndexPatterns.transaction,
        span: dataSources.apmIndexPatterns.span,
        error: dataSources.apmIndexPatterns.error,
        metric: dataSources.apmIndexPatterns.metric
      },
      logs: dataSources.logIndexPatterns,
      metrics: dataSources.metricIndexPatterns,
      alerts: dataSources.alertsIndexPattern
    },
    dataStreams
  };
}