"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getToolHandler = getToolHandler;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getToolHandler({
  request,
  dataRegistry,
  serviceName,
  serviceEnvironment,
  start,
  end
}) {
  const dependencies = await dataRegistry.getData('apmDownstreamDependencies', {
    request,
    serviceName,
    serviceEnvironment: serviceEnvironment !== null && serviceEnvironment !== void 0 ? serviceEnvironment : '',
    start,
    end
  });
  return {
    dependencies
  };
}