"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCorrelatedLogsForAnchor = getCorrelatedLogsForAnchor;
var _moment = _interopRequireDefault(require("moment"));
var _get_typed_search = require("../../utils/get_typed_search");
var _dsl_filters = require("../../utils/dsl_filters");
var _get_total_hits = require("../../utils/get_total_hits");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getCorrelatedLogsForAnchor({
  esClient,
  anchorLog,
  logsIndices,
  logger,
  logSourceFields,
  maxLogsPerSequence
}) {
  const search = (0, _get_typed_search.getTypedSearch)(esClient.asCurrentUser);
  const {
    correlation,
    '@timestamp': timestamp
  } = anchorLog;
  const start = (0, _moment.default)(timestamp).subtract(1, 'hour').valueOf();
  const end = (0, _moment.default)(timestamp).add(1, 'hour').valueOf();
  logger.debug(`Fetching correlated logs using ${correlation.field}=${correlation.value} between ${start} - ${end}`);
  const res = await search({
    _source: logSourceFields,
    track_total_hits: maxLogsPerSequence + 1,
    // +1 to check if sequence is truncated
    size: maxLogsPerSequence,
    index: logsIndices,
    sort: [{
      '@timestamp': {
        order: 'asc'
      }
    }],
    query: {
      bool: {
        filter: [...(0, _dsl_filters.timeRangeFilter)('@timestamp', {
          start,
          end
        }), {
          term: {
            [correlation.field]: correlation.value
          }
        }]
      }
    }
  });
  const totalHits = (0, _get_total_hits.getTotalHits)(res);
  return {
    logs: res.hits.hits.map(hit => hit._source),
    isTruncated: totalHits > maxLogsPerSequence
  };
}