"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnchorLogById = getAnchorLogById;
var _lodash = require("lodash");
var _get_typed_search = require("../../../utils/get_typed_search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getAnchorLogById({
  esClient,
  logsIndices,
  logId,
  correlationFields,
  logger
}) {
  const search = (0, _get_typed_search.getTypedSearch)(esClient.asCurrentUser);
  const response = await search({
    size: 1,
    track_total_hits: false,
    _source: false,
    fields: ['@timestamp', ...correlationFields],
    index: logsIndices,
    query: {
      ids: {
        values: [logId]
      }
    }
  });
  const hit = (0, _lodash.first)(response.hits.hits);
  if (!hit) {
    logger.warn(`Log with ID ${logId} not found in indices: ${logsIndices.join(', ')}`);
    return undefined;
  }
  return getAnchorLogFromHit(hit, correlationFields);
}
function getAnchorLogFromHit(hit, correlationFields) {
  if (!hit) return undefined;
  const correlationIdentifier = correlationFields.map(correlationField => {
    var _hit$fields;
    const timestamp = (0, _lodash.first)((_hit$fields = hit.fields) === null || _hit$fields === void 0 ? void 0 : _hit$fields['@timestamp']);
    const value = (0, _lodash.first)((0, _lodash.get)(hit.fields, correlationField));
    const anchorLogId = hit._id;
    return {
      '@timestamp': timestamp,
      correlation: {
        field: correlationField,
        value,
        anchorLogId
      }
    };
  }).find(({
    correlation
  }) => correlation.value != null);
  return correlationIdentifier;
}