"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_TIME_RANGE = exports.DEFAULT_LOG_SOURCE_FIELDS = exports.DEFAULT_CORRELATION_IDENTIFIER_FIELDS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Correlation identifier fields in priority order
const DEFAULT_CORRELATION_IDENTIFIER_FIELDS = exports.DEFAULT_CORRELATION_IDENTIFIER_FIELDS = ['trace.id', 'trace_id', 'x-trace-id', 'request.id', 'request_id', 'x_request_id', 'transaction.id', 'correlation.id', 'correlation_id', 'x-correlation-id', 'http.request.id', 'session.id', 'session_id', 'event.id', 'cloud.trace_id', 'parent.id', 'span.id', 'process.pid'];
const DEFAULT_LOG_SOURCE_FIELDS = exports.DEFAULT_LOG_SOURCE_FIELDS = ['@timestamp', 'message',
// OpenTelemetry log fields
'body.text', 'severity_text', 'severity_number',
// Correlation fields
...DEFAULT_CORRELATION_IDENTIFIER_FIELDS,
// Error severity fields
'log.level', 'level', 'severity', 'event.severity',
// Service fields
'service.*',
// Host fields
'host.*',
// Container fields
'container.*',
// Kubernetes fields
'kubernetes.*',
// Cloud fields
'cloud.*',
// Error fields
'error.*',
// Event fields
'event.*',
// HTTP/URL/User Agent fields
'url.*', 'user_agent.*', 'http.request.method', 'http.response.status_code', 'client.ip'];
const DEFAULT_TIME_RANGE = exports.DEFAULT_TIME_RANGE = {
  start: 'now-1h',
  end: 'now'
};