"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAttachments = registerAttachments;
var _ai_insight = require("./ai_insight");
var _error = require("./error");
var _alert = require("./alert");
var _log = require("./log");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function registerAttachments({
  core,
  plugins,
  logger,
  dataRegistry
}) {
  const attachmentTypes = [(0, _ai_insight.createAiInsightAttachmentType)(), (0, _error.createErrorAttachmentType)({
    core,
    logger,
    dataRegistry
  }), (0, _alert.createAlertAttachmentType)({
    core,
    logger
  }), (0, _log.createLogAttachmentType)({
    core,
    logger,
    dataRegistry
  })];
  for (const attachment of attachmentTypes) {
    plugins.onechat.attachments.registerType(attachment);
  }
}