"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLicense = void 0;
var _react = require("react");
var _rxjs = require("rxjs");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLicense = () => {
  var _services$licensing$l, _services$licensing;
  const {
    services
  } = (0, _use_kibana.useKibana)();
  const license = (0, _useObservable.default)((_services$licensing$l = (_services$licensing = services.licensing) === null || _services$licensing === void 0 ? void 0 : _services$licensing.license$) !== null && _services$licensing$l !== void 0 ? _services$licensing$l : new _rxjs.Observable(), null);
  return {
    getLicense: () => license,
    hasAtLeast: (0, _react.useCallback)(level => {
      if (!license) return;
      return !!license && license.isAvailable && license.isActive && license.hasAtLeast(level);
    }, [license])
  };
};
exports.useLicense = useLicense;